using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline;
using Microsoft.Xna.Framework.Content.Pipeline.Graphics;
using FontContent;

// TODO: replace this with the type you want to import.
using TImport = FontContent.Fuente;

namespace FontContentPipelineExtension
{
    /// <summary>
    /// This class will be instantiated by the XNA Framework Content Pipeline
    /// to import a file from disk into the specified type, TImport.
    /// 
    /// This should be part of a Content Pipeline Extension Library project.
    /// 
    /// TODO: change the ContentImporter attribute to specify the correct file
    /// extension, display name, and default processor for this importer.
    /// </summary>
    /// <summary>
    /// This class will be instantiated by the XNA Framework Content Pipeline
    /// to import a file from disk into the specified type, TImport.
    /// 
    /// This should be part of a Content Pipeline Extension Library project.
    /// 
    /// TODO: change the ContentImporter attribute to specify the correct file
    /// extension, display name, and default processor for this importer.
    /// </summary>
    [ContentImporter(".fpr", DisplayName = "Font Importer", DefaultProcessor = "FontContentProcessor")]
    public class FontContentImporter : ContentImporter<TImport>
    {
        public override TImport Import(string filename, ContentImporterContext context)
        {
            Fuente texto = new Fuente();
            String[] datos;
            int numLetras;
            FileStream file = new FileStream(filename, FileMode.Open);
            StreamReader stream = new StreamReader(file);
            datos = SplitClasificado(stream.ReadLine());
            if (datos[0].Equals("Letras"))
            {
                numLetras = Convert.ToInt32(datos[1]);
            }
            else throw new Exception("Etiqueta letras no encontrada.");
            datos = SplitClasificado(stream.ReadLine());
            if (datos[0].Equals("minChar"))
            {
                texto.minChar = Convert.ToInt32(datos[1]);
            }
            else throw new Exception("Etiqueta minChar no encontrada.");

            datos = SplitClasificado(stream.ReadLine());
            if (datos[0].Equals("maxChar"))
            {
                texto.maxChar = Convert.ToInt32(datos[1]);
            }
            else throw new Exception("Etiqueta maxChar no encontrada.");
            // Bucle de lectura de letras
            texto.letras = new Letra[numLetras];
            for (int indx = 0; indx < numLetras; indx++)
            {
                datos = SplitDatos(stream.ReadLine());
                int mx = Convert.ToInt32(datos[1]);
                int my = Convert.ToInt32(datos[2]);
                int lx = Convert.ToInt32(datos[3]);
                int ly = Convert.ToInt32(datos[4]);
                texto.letras[indx] = new Letra(mx, my, lx, ly);
            }
            stream.Close();
            file.Close();
            return texto;
        }

        #region Funciones auxiliares de carga

        private String[] SplitClasificado(String linea)
        {
            linea = linea.Substring(1, linea.Length - 2);
            return linea.Split('=');
        }

        private String[] SplitDatos(String linea)
        {
            return linea.Split(',');
        }

        #endregion

    }
}
