using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace Game
{
    /// <summary>
    /// This is a game component that implements IUpdateable.
    /// </summary>
    public class DefaultScene
    {
        public delegate void EventDelegate(); 
        public event EventDelegate Exit;
        public event EventDelegate Next;

        public Dictionary<String, Object> Parameters; 

        protected List<AbstractProcessor> Components;

        private Microsoft.Xna.Framework.Game game;

        public GraphicsDevice GraphicsDevice { get { return this.game.GraphicsDevice; } }
        public ContentManager Content { get { return this.game.Content; } }

        public DefaultScene(Microsoft.Xna.Framework.Game game)
        {
            this.Parameters = new Dictionary<String, Object>();
            this.Components = new List<AbstractProcessor>();
            this.game = game; 
        }

        public virtual void RaiseExit()
        {
            this.Exit();
        }

        public virtual void RaiseNext()
        {
            this.Next();
        }

        public virtual void Initialize()
        {
            foreach (AbstractProcessor component in Components)
            {
                component.Initialize();
            }
        }

        public virtual void LoadContent()
        {
            foreach (AbstractProcessor component in Components)
            {
                component.LoadContent();
            }
        }

        public virtual void UnloadContent()
        {
            foreach (AbstractProcessor component in Components)
            {
                component.UnloadContent();
            }
        }

        public virtual void Update(GameTime gameTime)
        {
            foreach (AbstractProcessor component in Components)
            {
                if ( component.enabled ) component.Update(gameTime);
            }
        }

        public virtual void Draw(GameTime gameTime)
        {
            foreach (AbstractProcessor component in Components)
            {
                if ( component.visible ) component.Draw(gameTime);
            }
        }
    }
}
