﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework; 

namespace Game.Entidades
{
    public class Cubo
    {
        private Vector3 posicion = Vector3.Zero; 
        // Indicadores de posicion 
        public Vector3 MatrizPosicion = Vector3.Zero;
        public Vector3 Posicion
        {
            get { return this.posicion; }
        }
        public float PosicionBase
        {
            get { return posicion.Y; }
        }
        public float PosicionSuper
        {
            get { return posicion.Y+1.0f; }
        }
        // Indicador de escala. 
        public float Escala; 

        // indicador de color
        private Int32 refColor;
        public Int32 Color { get { return this.refColor; } }
        
        // indicador de tiempo; 
        private Int32 contador;
        public Int32 Lapso { get { return ((int)(this.contador/1000)); } }

        // indicador de estado
        private Boolean armado;
        public Boolean EstaArmado { get { return this.armado; } }

        // Es un detonador; 
        private Boolean detonador;
        public Boolean EsDetonador { get { return this.detonador; } }

        // Indicador de explosion
        private Boolean explosion;
        public Boolean EsExplosion { get { return this.explosion; } }
        public void Explota() { explosion = true; }

        private static Random rnd = new Random();

        public static Cubo GenerarCuboTransferencia(int color)
        {
            return new Cubo(rnd.Next(1, 100) % 4, false) { Escala = 0.0f }; 
            //return new Cubo(color, false) { Escala = 0.0f }; 
        }


        public static Cubo GenerarCuboJugador( int cubosExistentes)
        {
            int random = rnd.Next(1, 100);
            int refColor = random % 4;
            // Los cubos transferidos nunca son detonadores
            float probNecesidadDetonadores = cubosExistentes / Parametros.MAX_CUBOS_MATRIX;
            //bool detonador = random > (100 - (probNecesidadDetonadores * 75.0f));
            bool detonador = random > 75; 
            Cubo cubo =  new Cubo(refColor, detonador);     
            return cubo; 
        }

        public Cubo( int _refColor, bool _detonador)
        {
            this.posicion = new Vector3(0.0f, Parametros.START_Y, 0.0f);
            this.refColor = _refColor;
            this.contador = Parametros.DETONADOR_TIEMPO;
            this.armado = false;
            this.detonador = _detonador;
            this.Escala = 1.0f; 
        }

        #region Control de tiempos

        public void Temporizador(int milisegundos)
        {
            if (!armado)
            {
                contador -= milisegundos/2;
                if (contador < 0) armado = true; 
            }
        }

        #endregion 

        #region Control de movimiento

        public void Caer(float dy)
        {
            this.FijarPosicion(posicion.X, posicion.Y - dy, posicion.Z);
        }

        public void MoverPosicionHorizontal(float x, float z)
        {
            this.FijarPosicion(x, posicion.Y, z); 
        }

        public void MoverPosicionVertical(float y)
        {
            this.FijarPosicion(posicion.X, y, posicion.Z);
        }

        private void FijarPosicion(float x, float y, float z)
        {
            posicion = new Vector3(x, y, z);
        }

        #endregion 

        #region Control de posado 

        public void Posar(Cubo cubo)
        {
            if (cubo != null)
            {
                this.FijarPosicion(this.posicion.X, cubo.PosicionSuper, posicion.Z);
            }
            else
            {
                this.FijarPosicion(this.posicion.X, 0.0f, posicion.Z);
            }
        }

        #endregion 


    }
}
