﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework; 

namespace Game.Entidades
{
    public class Jugador
    {
        Random rnd = new Random(DateTime.Now.Millisecond);

        // Coordenadas de lanzamiento de cubo
        public Int32 X;
        public Int32 Z;
        public float Y; 

        private Cubo cubo = null;
        public Cubo Cubo { get { return this.cubo; } }
        private Cubo proximo = null;
        public Cubo Proximo { get { return this.proximo; } }

        public Jugador()
        {
            X = 0;
            Z = 0;
            proximo = Cubo.GenerarCuboJugador(0);
            NuevoCubo(0);
        }

        public void Posicionar(int posX, int posZ)
        {
            X = posX;
            Z = posZ;
            if (cubo != null) cubo.MoverPosicionHorizontal(X, Z);
        }

        public void MoverHorizontal(int dX, int dZ)
        {
            X += dX;
            Z += dZ; 
            if (cubo != null) cubo.MoverPosicionHorizontal(X, Z);
        }

        public void MoverVertical(float dy)
        {
            Y -= dy;
            cubo.MoverPosicionVertical(Y);
        }

        public void NuevoCubo( int cubosExistentes)
        {
            Y = Parametros.START_Y;
            cubo = proximo;
            cubo.MoverPosicionHorizontal(X, Z);
            proximo = Cubo.GenerarCuboJugador( cubosExistentes);
        }
    }
}
