﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework; 

namespace Game.Entidades
{
    public class Matriz
    {


        public float rotacion = 0.0f; 

        public Boolean Rotura;

        public List<Cubo>[,] coleccion = new List<Cubo>[Parametros.MAX_X, Parametros.MAX_Z];

        public Matriz()
        {
            for (int x = 0; x < Parametros.MAX_X; x++)
            {
                for (int z = 0; z < Parametros.MAX_Z; z++)
                {
                    coleccion[x, z] = new List<Cubo>();
                }
            }
            Rotura = false;
            rotacion = 0.0f; 
        }

        public int ObtenerTotalCubos()
        {
            int total = 0; 
            foreach (List<Cubo> columna in coleccion)
            {
                total += columna.Count(); 
            }
            return total; 
        }

        public int ObtenerColorColumna(int X, int y, int colorCubo)
        {
            List<Cubo> columna = coleccion[X, y];
            return columna.Count(cubo => cubo.Color == colorCubo);
        }

        public void ObtenerColumnaMenor(out int colX, out int colZ)
        {
            colX = 0;
            colZ = 0;
            for (int x = 0; x < Parametros.MAX_X; x++)
            {
                for (int z = 0; z < Parametros.MAX_Z; z++)
                {
                    if (coleccion[x, z].Count < coleccion[colX, colZ].Count)
                    {
                        colX = x;
                        colZ = z; 
                    }
                }
            } 
        }

        public float ObtenerPosado(int X, int Z)
        {
            List<Cubo> columna = coleccion[X,Z];
            return (columna.Count > 0) ? columna[columna.Count - 1].PosicionSuper : 0.0f; 
        }

        public int ObtenerAltura( int X, int Z ) {
            return coleccion[X, Z].Count; 
        }

        public Cubo ObtenerUltimoCubo(int X, int Z)
        {
            List<Cubo> columna = coleccion[X, Z];
            if (columna.Count > 0)
            {
                Cubo cubo = columna[columna.Count - 1];
                cubo.MatrizPosicion = new Vector3(X, columna.Count - 1, Z);
                return cubo;
            }
            else return null;  
        }

        public Cubo ObtenerCubo(int X, int Z, int altura)
        {
            if (X < 0 || X >= Parametros.MAX_X) return null;
            if (Z < 0 || Z >= Parametros.MAX_Z) return null;
            if (altura < 0 || altura >= coleccion[X, Z].Count) return null; 
            List<Cubo> columna = coleccion[X, Z];
            Cubo cubo = columna[altura];
            cubo.MatrizPosicion = new Vector3(X, altura, Z);
            return cubo; 
        }

        public Boolean ComprobarPosar(Cubo cubo)
        {
            List<Cubo> columna = coleccion[(int)cubo.Posicion.X, (int)cubo.Posicion.Z];
            float suelo = (columna.Count > 0) ? columna[columna.Count - 1].PosicionSuper : 0.0f;
            return (cubo.PosicionBase <= suelo);
        }

        public void Posar(Cubo cubo)
        {
            List<Cubo> columna = coleccion[(int)cubo.Posicion.X, (int)cubo.Posicion.Z];
            if (columna.Count > 0)
            {
                Cubo ultimoCubo = columna[columna.Count - 1];
                cubo.Posar(ultimoCubo);
                columna.Add(cubo);
                Rotura = (columna.Count > Parametros.MAX_Y);
            }
            else
            {
                cubo.Posar(null);
                columna.Add(cubo);
            }
        }
    }
}
