using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;


namespace Game.Graficos
{
    /// <summary>
    /// This is a game component that implements IUpdateable.
    /// </summary>
    public class EscenarioProcessor : AbstractProcessor
    {
        private GameScene Main;

        private Plano planoSup;
        private Plano planoInf; 
        public EscenarioProcessor(DefaultScene game)
            : base(game)
        {
            this.Main = game as GameScene; 
        }

        public override void Initialize()
        {
        }

        public override void LoadContent()
        {
            planoSup = new Plano(GraphicsDevice, Recursos.suelo);
            planoInf = new Plano(GraphicsDevice, Recursos.suelo);
        }


        public override void UnloadContent()
        {
        }

        public override void Update(GameTime gameTime)
        {
        }

        public override void Draw(GameTime gameTime)
        {
            for (PlayerIndex player = PlayerIndex.One; player <= PlayerIndex.Two; player++)
            {
                planoInf.Draw(Main.camara,
                        Main.vistas[(int)player],
                        Matrix.CreateRotationX(-MathHelper.PiOver2) *
                        Matrix.CreateRotationY(Main.matrices[(int)player].rotacion));
                planoSup.Draw(Main.camara,
                        Main.vistas[(int)player],
                        Matrix.CreateRotationX(-MathHelper.PiOver2) *
                        Matrix.CreateRotationY(Main.matrices[(int)player].rotacion) *
                        Matrix.CreateTranslation(0.0f, Parametros.MAX_Y, 0.0f));
            }

        }

    }
}
