﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

using Game.Entidades;
using Game.Graficos;
using Game.Servicios;

namespace Game.Graficos
{
    class FondoMenuProcessor:AbstractProcessor
    {
        private MenuScene main; 

        private float angulo; 

        private Plano fondo;
        private Matrix fondo_world = Matrix.CreateScale(new Vector3(2.0f, 1.0f, 1.0f));
        private Plano titulo;
        private Matrix titulo_world = Matrix.CreateScale(new Vector3(.75f, .15f, 1.0f)) * Matrix.CreateTranslation(new Vector3(0.0f, 1.35f, 0.5f));
        private Plano sombra;
        private Matrix sombra_world = Matrix.CreateScale(new Vector3(.8f, .2f, 1.0f)) * Matrix.CreateTranslation(new Vector3(0.0f, 1.2f, 0.1f));

        private Plano controles;
        private Matrix controles_world = Matrix.CreateScale(new Vector3(.5f, .5f, 1.0f)) * Matrix.CreateTranslation(new Vector3(-2.0f, -.5f, 0.5f));
        private Plano controles_sombra;
        private Matrix controles_sombra_world = Matrix.CreateScale(new Vector3(.55f, .55f, 1.0f)) * Matrix.CreateTranslation(new Vector3(-2.0f, -.75f, 0.1f));

        public FondoMenuProcessor(DefaultScene scene)
            : base(scene)
        {
            this.main = scene as MenuScene; 
        }

        public override void Initialize()
        {
            angulo = 0.0f; 
        }

        public override void LoadContent()
        {
            Recursos.TTitulo = Content.Load<Texture2D>(@"menu/titulo");
            Recursos.FondoMenu = Content.Load<Texture2D>(@"menu/fondo");
            Recursos.TTituloSombra = Content.Load<Texture2D>(@"menu/sombra");
            Recursos.TAyudaControles = Content.Load<Texture2D>(@"menu/controles");
            Recursos.TAyudaJuego = Content.Load<Texture2D>(@"menu/juego");
            Recursos.TAyudaMarcadores = Content.Load<Texture2D>(@"menu/marcadores");
            Recursos.TAyudaSombra = Content.Load<Texture2D>(@"menu/controlesSombra");
            fondo = new Plano(GraphicsDevice, Recursos.FondoMenu);
            titulo = new Plano(GraphicsDevice, Recursos.TTitulo);
            sombra = new Plano(GraphicsDevice, Recursos.TTituloSombra);
            controles = new Plano(GraphicsDevice, Recursos.TAyudaControles);
            controles_sombra = new Plano(GraphicsDevice, Recursos.TAyudaSombra);
        }

        public override void UnloadContent()
        {
        }

        public override void Update(Microsoft.Xna.Framework.GameTime gameTime)
        {
            angulo += .5f;
            angulo %= 360;
            main.camara.position = Vector3.Transform(new Vector3(0.0f, .5f, 6.0f), Matrix.CreateRotationZ(MathHelper.ToRadians(angulo)));
            main.camara.RefrescarTransformaciones();
        }

        public override void Draw(Microsoft.Xna.Framework.GameTime gameTime)
        {
            fondo.Draw(main.camara, main.vista, fondo_world);
            sombra.Draw(main.camara, main.vista, sombra_world);
            titulo.Draw(main.camara, main.vista, titulo_world);
            // Visualizacion de ayuda de controles
            if (main.AyudaVisible )
            {
                controles_sombra.Draw(main.camara, main.vista, controles_sombra_world);
                switch (main.AyudaSeleccionada)
                {
                    case Parametros.SUBOPC_AYUDA_CONTROLES:
                        controles.Draw(main.camara, main.vista, controles_world, Recursos.TAyudaControles);
                        break;
                    case Parametros.SUBOPC_AYUDA_JUEGO:
                        controles.Draw(main.camara, main.vista, controles_world, Recursos.TAyudaJuego);
                        break;
                    case Parametros.SUBOPC_AYUDA_MARCADORES:
                        controles.Draw(main.camara, main.vista, controles_world, Recursos.TAyudaMarcadores);
                        break; 
                }
            }
        }
    }
}
