using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

using Game.Entidades; 
using Game.Servicios; 

using FontContent; 

namespace Game.Graficos
{
    /// <summary>
    /// This is a game component that implements IUpdateable.
    /// </summary>
    public class HUDProcessor : AbstractProcessor
    {
        private FontBatch fontBatch;
 
        private Viewport vista;
        
        private GameScene Main;
        
        private PlayerIndex player;

        private Transferencia jugador;
        private Transferencia enemigo;

        private int fliflop = 0; 

        public HUDProcessor(DefaultScene game, PlayerIndex player)
            : base(game)
        {
            this.player = player;
            this.Main = game as GameScene;
            this.vista = Main.vistas[(int)player];

            if (this.player == PlayerIndex.One)
            {
                jugador = Main.transferencias[(int)PlayerIndex.One];
                enemigo = Main.transferencias[(int)PlayerIndex.Two]; 
            }
            else
            {
                jugador = Main.transferencias[(int)PlayerIndex.Two];
                enemigo = Main.transferencias[(int)PlayerIndex.One];
            }
        }

        public override void Initialize()
        {
        }

        public override void LoadContent()
        {
            this.fontBatch = new FontBatch(
                                new SpriteBatch(GraphicsDevice),
                                Content.Load<Fuente>(@"fuentes/ptrEras48"),
                                Content.Load<Texture2D>(@"fuentes/Eras48"));
        }

        public override void UnloadContent()
        {
        }

        public override void Update(GameTime gameTime)
        {
        }

        public override void Draw(GameTime gameTime)
        {
            fliflop++;
            fliflop %= 10; 
            
            GraphicsDevice.Viewport = this.vista;


            this.fontBatch.DrawText(jugador.TotalCubosEntrada.ToString(), 10, 10, 1.5f, Color.Cyan);
            if ( jugador.TieneEntrada ) this.fontBatch.DrawText("x" + jugador.Multiplicador.ToString(), 60, 80, .75f, ( fliflop < 5 ) ? Color.White : Color.Cyan);
            if ( jugador.TieneEntrada ) this.fontBatch.DrawText("T:" + ((int)jugador.Tiempo / 100).ToString(), 10, 120, .5f, Color.Yellow);
            if (enemigo.TieneSalida)
            {
                this.fontBatch.DrawText(enemigo.TotalCubosSalida.ToString(), vista.Width - 180, 15, 1.25f, (fliflop < 5) ? Color.Yellow : Color.Salmon);
                this.fontBatch.DrawText("Llegada:", vista.Width - 180, 5, .4f, Color.White);
            }

            this.fontBatch.DrawText("Salida:", 5, 5, .4f, Color.White);
        }
        
    }
}
