﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

using FontContent;

using Game.Entidades;
using Game.Graficos;
using Game.Servicios;

namespace Game.Graficos
{
    class OpcionesMenuProcessor:AbstractProcessor
    {
        private int LeftMargin = Parametros.RESOLUCION_W / 2; 
        private int TopMargin = 275;

        private Color colorOpcion = Color.White;
        private Color colorSeleccion = Color.Salmon; 

        private MenuScene main;

        private SpriteBatch spriteBatch; 
        private FontBatch digitalFontBatch;
        private FontBatch erieFontBatch;

        private AudioService audio; 

        private int OpcionSeleccionada = 0;
        private int timer = 0;

        String[] textosDificultad = { "<FACIL>", "<NORMAL>", "<DIFICIL>" };
        String[] textosAyuda = { "<CONTROLES>", "<JUEGO>", "<MARCADORES>" }; 

        public OpcionesMenuProcessor(DefaultScene scene)
            : base(scene)
        {
            this.main = scene as MenuScene; 
        }

        public override void Initialize()
        {

        }

        public override void LoadContent()
        {
            this.spriteBatch = new SpriteBatch( GraphicsDevice );
            this.digitalFontBatch = new FontBatch(
                                new SpriteBatch(GraphicsDevice),
                                Content.Load<Fuente>(@"fuentes/ptrfuente"),
                                Content.Load<Texture2D>(@"fuentes/fuente"));
            this.erieFontBatch = new FontBatch(
                                new SpriteBatch(GraphicsDevice),
                                Content.Load<Fuente>(@"fuentes/ptrEras48"),
                                Content.Load<Texture2D>(@"fuentes/Eras48"));
            this.audio = new AudioService(new SoundEffect[] { Content.Load<SoundEffect>(@"sonidos/seleccion"), 
                                                                Content.Load<SoundEffect>(@"sonidos/opcion")});
        }

        public override void UnloadContent()
        {

        }

        public override void Update(GameTime gameTime)
        {
            timer += gameTime.ElapsedGameTime.Milliseconds;
            timer %= 255; 
            ControlProcessor control = main.control;
            if (control.Fondo)
            {
                if (OpcionSeleccionada > Parametros.OPC_PLAYER_VS_CPU) OpcionSeleccionada--;
                audio.Play(Parametros.SONIDO_SELECCION);
            }
            if (control.Frente)
            {
                if (OpcionSeleccionada < Parametros.OPC_SALIDA) OpcionSeleccionada++;
                audio.Play(Parametros.SONIDO_SELECCION);
            }
            if (control.Derecha)
            {
                switch (OpcionSeleccionada) { 
                    case Parametros.OPC_PLAYER_VS_CPU:
                        audio.Play(Parametros.SONIDO_OPCION);
                        if (main.DificultadIASeleccionada < Parametros.IA_MODO_DIFICIL)
                            main.DificultadIASeleccionada++; 
                        break;
                    case Parametros.OPC_AYUDA:
                        audio.Play(Parametros.SONIDO_OPCION);
                        if (main.AyudaSeleccionada < Parametros.SUBOPC_AYUDA_MARCADORES)
                            main.AyudaSeleccionada++; 
                        break; 
                }
            }
            if (control.Izquierda)
            {
                switch (OpcionSeleccionada)
                {
                    case Parametros.OPC_PLAYER_VS_CPU:
                        audio.Play(Parametros.SONIDO_OPCION);
                        if (main.DificultadIASeleccionada > Parametros.IA_MODO_FACIL)
                            main.DificultadIASeleccionada--;
                        break;
                    case Parametros.OPC_AYUDA:
                        audio.Play(Parametros.SONIDO_OPCION);
                        if (main.AyudaSeleccionada > Parametros.SUBOPC_AYUDA_CONTROLES)
                            main.AyudaSeleccionada--;
                        break;
                }
            }

            if (control.Posar || Keyboard.GetState().IsKeyDown(Keys.Enter))
            {
                audio.Play(Parametros.SONIDO_OPCION);
                switch (OpcionSeleccionada)
                {
                    case Parametros.OPC_PLAYER_VS_PLAYER:
                    case Parametros.OPC_PLAYER_VS_CPU:
                        main.Parameters.Add(Parametros.PARAM_OPCION_SELECCIONADA, OpcionSeleccionada);
                        main.Parameters.Add(Parametros.PARAM_IADIFICULTAD_SELECCIONADA, main.DificultadIASeleccionada);
                        main.RaiseNext();
                        break; 
                    case Parametros.OPC_AYUDA:
                        main.AyudaVisible = !main.AyudaVisible;
                        break; 
                    case Parametros.OPC_SALIDA:
                        main.RaiseExit();
                        break; 
                }
            }
        }

        public override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Viewport = main.vista;
            colorSeleccion = new Color(255, timer, timer);
            this.digitalFontBatch.DrawShadowText("1 JUGADOR", LeftMargin, TopMargin, 1.0f, (this.OpcionSeleccionada == Parametros.OPC_PLAYER_VS_CPU) ? colorSeleccion : colorOpcion, 0, 7);
            this.digitalFontBatch.DrawShadowText(textosDificultad[main.DificultadIASeleccionada], LeftMargin + 80, TopMargin + 40, .8f, (this.OpcionSeleccionada == Parametros.OPC_PLAYER_VS_CPU) ? colorSeleccion : colorOpcion, 0, 7);

            this.digitalFontBatch.DrawShadowText("2 JUGADORES", LeftMargin, TopMargin + 100, 1.0f, (this.OpcionSeleccionada == Parametros.OPC_PLAYER_VS_PLAYER) ? colorSeleccion : colorOpcion, 0, 7);

            this.digitalFontBatch.DrawShadowText("AYUDA", LeftMargin, TopMargin + 150, 1.0f, (this.OpcionSeleccionada == Parametros.OPC_AYUDA) ? colorSeleccion : colorOpcion, 0, 7);
            this.digitalFontBatch.DrawShadowText(textosAyuda[main.AyudaSeleccionada], LeftMargin + 80, TopMargin + 190, .8f, (this.OpcionSeleccionada == Parametros.OPC_AYUDA) ? colorSeleccion : colorOpcion, 0, 7);

            //this.fontBatch.DrawShadowText("VIDEO", LeftMargin, TopMargin + 250, 1.0f, (this.OpcionSeleccionada == Parametros.OPC_VIDEO) ? colorSeleccion : colorOpcion, 0, 7);
            //this.fontBatch.DrawShadowText("< FACIL >", LeftMargin + 80, TopMargin + 290, .8f, (this.OpcionSeleccionada == Parametros.OPC_VIDEO) ? colorSeleccion : colorOpcion, 0, 7);

            this.digitalFontBatch.DrawShadowText("SALIR", LeftMargin, TopMargin + 250, 1.0f, (this.OpcionSeleccionada == Parametros.OPC_SALIDA) ? colorSeleccion : colorOpcion, 0, 7);

            this.erieFontBatch.DrawShadowText("ELEGIR: [CURSORES]. SELECCIONAR: [ESPACIO/ENTER]", LeftMargin, TopMargin + 350, .3f, Color.Silver, 0, 7);
            this.erieFontBatch.DrawShadowText("The AerishanDae Company Inc.", 10, main.vista.Height-20, .3f, Color.White, 0, 7);
        }
    }
}
