﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics; 

namespace Game.Graficos
{
    class Plano
    {
        private VertexPositionTexture[] vertex;
        private VertexBuffer vertexBuffer;
        private Texture2D texture; 
        private BasicEffect shader;

        private GraphicsDevice GraphicsDevice;

        public Plano(GraphicsDevice _graphicsDevice) : this(_graphicsDevice, null) { }

        public Plano(GraphicsDevice _graphicsDevice, Texture2D texture)
        {
            this.texture = texture; 
            this.GraphicsDevice = _graphicsDevice;
            shader = new BasicEffect(GraphicsDevice);
            List<VertexPositionTexture> lvertex = new List<VertexPositionTexture>();
            lvertex.Add(new VertexPositionTexture(new Vector3(-3.0f, 3.0f, 0.0f), new Vector2(0.0f, 0.0f)));
            lvertex.Add(new VertexPositionTexture(new Vector3(3.0f, 3.0f, 0.0f), new Vector2(1.0f, 0.0f)));
            lvertex.Add(new VertexPositionTexture(new Vector3(-3.0f, -3.0f, 0.0f), new Vector2(0.0f, 1.0f)));
            lvertex.Add(new VertexPositionTexture(new Vector3(3.0f, -3.0f, 0.0f), new Vector2(1.0f, 1.0f)));
            vertex = lvertex.ToArray<VertexPositionTexture>();
            vertexBuffer = new VertexBuffer(GraphicsDevice, typeof(VertexPositionTexture), vertex.Length, BufferUsage.None);
            vertexBuffer.SetData(vertex);
        }

        public void Draw(Camara camara, Viewport vista, Matrix world, Texture2D _texture)
        {
            this.texture = _texture;
            this.Draw( camara, vista, world );
        }

        public void Draw(Camara camara, Viewport vista, Matrix world)
        {
            GraphicsDevice.Viewport = vista; 
            GraphicsDevice.SetVertexBuffer(vertexBuffer);
            shader.TextureEnabled = true;
            shader.Texture = texture;
            shader.World = world; 
            //shader.World = Matrix.CreateRotationX(-MathHelper.PiOver2) * Matrix.CreateRotationY(rotacion);
            shader.View = camara.view;
            shader.Projection = camara.projection;
            foreach (EffectPass pass in shader.CurrentTechnique.Passes)
            {
                pass.Apply();
                GraphicsDevice.DrawUserPrimitives<VertexPositionTexture>(
                    PrimitiveType.TriangleStrip, vertex, 0, 2);
            }
        }


    }
}
