﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework; 
using Microsoft.Xna.Framework.Graphics;

namespace Game.Graficos
{
    public class RejillaProcessor: AbstractProcessor
    {
        private VertexPositionColor[] vertex;
        private VertexBuffer vertexBuffer;
        private BasicEffect shader; 

        private GameScene Main; 

        public RejillaProcessor( DefaultScene game)
            :base( game )
        {
            Main = (GameScene)game; 
        }

        public override void Initialize()
        {
        }

        public override void LoadContent()
        {
            shader = new BasicEffect(this.GraphicsDevice);
            shader.VertexColorEnabled = true; 
            List<VertexPositionColor> lvertex = new List<VertexPositionColor>();
            for (int y = -10; y <= 10; y++)
            {
                lvertex.Add(new VertexPositionColor(new Vector3(+10.0f, y, 0.0f), Color.Red));
                lvertex.Add(new VertexPositionColor(new Vector3(-10.0f, y, 0.0f), Color.Red));
            }
            for (int x = -10; x <= 10; x++)
            {
                lvertex.Add(new VertexPositionColor(new Vector3(x, +10.0f, 0.0f), Color.Cyan));
                lvertex.Add(new VertexPositionColor(new Vector3(x, -10.0f, 0.0f), Color.Cyan));
            }
            for (int z = -10; z <= 10; z++)
            {
                lvertex.Add(new VertexPositionColor(new Vector3(+10.0f, 0.0f, z), Color.Green));
                lvertex.Add(new VertexPositionColor(new Vector3(-10.0f, 0.0f, z), Color.Green));
            }
            for (int x = -10; x <= 10; x++)
            {
                lvertex.Add(new VertexPositionColor(new Vector3(x, 0.0f, +10.0f), Color.Cyan));
                lvertex.Add(new VertexPositionColor(new Vector3(x, 0.0f, -10.0f), Color.Cyan));
            }
            vertex = lvertex.ToArray<VertexPositionColor>();
            vertexBuffer = new VertexBuffer(this.GraphicsDevice, typeof(VertexPositionColor), vertex.Length, BufferUsage.None);
            vertexBuffer.SetData(vertex);
        }

        public override void UnloadContent()
        {
        }

        public override void Update(GameTime gameTime)
        {
        }

        public override void Draw(GameTime gameTime)
        {
            GraphicsDevice.SetVertexBuffer(vertexBuffer);
            shader.World = Matrix.Identity;
            shader.View = Main.camara.view;
            shader.Projection = Main.camara.projection;
            foreach (EffectPass pass in shader.CurrentTechnique.Passes)
            {
                pass.Apply();
                GraphicsDevice.DrawUserPrimitives<VertexPositionColor>(PrimitiveType.LineList, vertex, 0, vertex.Length / 2);
            }
            
        }
    }
}
