using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace Game
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class MainGame : Microsoft.Xna.Framework.Game
    {

        GraphicsDeviceManager graphics;

        DefaultScene currentScene; 

        public MainGame()
        {
            graphics = new GraphicsDeviceManager(this);
            graphics.PreferredBackBufferWidth = Parametros.RESOLUCION_W;
            graphics.PreferredBackBufferHeight = Parametros.RESOLUCION_H;
            graphics.IsFullScreen = Parametros.FULLSCREEN; 
            Content.RootDirectory = "Content";

            this.currentScene = new MenuScene(this);
            currentScene.Exit += new DefaultScene.EventDelegate(currentScene_Exit);
            currentScene.Next += new DefaultScene.EventDelegate(currentScene_Next);
        }

        void currentScene_Exit()
        {
            this.Exit();
        }

        void currentScene_Next()
        {
            if (currentScene is MenuScene)      // Del menu al juego
            {
                int opcionSeleccionada = (int)currentScene.Parameters[Parametros.PARAM_OPCION_SELECCIONADA];
                int dificultadSeleccionada = (int)currentScene.Parameters[Parametros.PARAM_IADIFICULTAD_SELECCIONADA]; 
                currentScene.UnloadContent();
                currentScene = null;

                currentScene = new GameScene(this);
                currentScene.Parameters.Add(Parametros.PARAM_OPCION_SELECCIONADA, opcionSeleccionada);
                currentScene.Parameters.Add(Parametros.PARAM_IADIFICULTAD_SELECCIONADA, dificultadSeleccionada);

            } else if (currentScene is GameScene)      // Del juego al menu
            {
                currentScene.UnloadContent();
                currentScene = null;

                currentScene = new MenuScene(this);
            }

            currentScene.Exit += new DefaultScene.EventDelegate(currentScene_Exit);
            currentScene.Next += new DefaultScene.EventDelegate(currentScene_Next);
            currentScene.Initialize();
            currentScene.LoadContent();
        }

        protected override void Initialize()
        {
            this.GraphicsDevice.BlendState = BlendState.AlphaBlend;
            this.currentScene.Initialize();
            base.Initialize();
        }

        protected override void LoadContent()
        {
            this.currentScene.LoadContent();
            base.LoadContent();
        }

        protected override void UnloadContent()
        {
            this.currentScene.UnloadContent();
            base.UnloadContent();
        }

        protected override void Update(GameTime gameTime)
        {
            this.currentScene.Update(gameTime);
            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Blue);
            this.currentScene.Draw(gameTime);
            base.Draw(gameTime);
        }
    }
}
