﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

using FontContent;

using Game.Entidades;
using Game.Graficos;
using Game.Servicios;

namespace Game
{
    public class MenuScene:DefaultScene
    {
        public Camara camara;
        public Viewport vista;

        public MusicaService musica; 

        private FondoMenuProcessor fondoComponente;
        private OpcionesMenuProcessor opcionesComponente;
        public ControlProcessor control;

        // Configuraciones de Usuario
        public int AyudaSeleccionada = Parametros.SUBOPC_AYUDA_CONTROLES;
        public Boolean AyudaVisible = false; 
        public int DificultadIASeleccionada = Parametros.IA_MODO_MEDIO;
 
        public MenuScene(Microsoft.Xna.Framework.Game game)
        :base(game )
        {
        }

        public override void Initialize()
        {
            camara = new Camara(new Vector3(0.0f, 1.0f, 6.0f), new Vector3(0.0f, 0.0f, 0.0f), Vector3.Up, 1280.0f/720.0f);
            vista = new Viewport(0, 0, Parametros.RESOLUCION_W, Parametros.RESOLUCION_H);
            fondoComponente = new FondoMenuProcessor(this);
            opcionesComponente = new OpcionesMenuProcessor(this);
            control = new ControlProcessor(this, PlayerIndex.One);
            // Componente de control
            Components.Add(control);
            // Componentes gráficos. 
            Components.Add(fondoComponente);
            Components.Add(opcionesComponente);
            base.Initialize();
        }

        public override void RaiseNext()
        {
            musica.Stop();
            base.RaiseNext();
        }

        public override void LoadContent()
        {
            musica = new MusicaService(Content.Load<SoundEffect>(@"musica/musicamenu.com"));
            base.LoadContent();
        }

        public override void Update(GameTime gameTime)
        {
            musica.Update();
            // Control de cierre
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed ||
                Keyboard.GetState().IsKeyDown(Keys.Escape))
            {
                this.RaiseExit();
            }
            base.Update(gameTime);
        }

        public override void Draw(GameTime gameTime)
        {
            base.Draw(gameTime);
        }

    }
}
