using System;
using System.IO; 

namespace Game
{
#if WINDOWS || XBOX
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        static void Main(string[] args)
        {
            String ruta = Path.Combine(Environment.CurrentDirectory, "config.cfg");
            if (File.Exists(ruta))
            {
                StreamReader sr = null; 
                try
                {
                    sr = new StreamReader(new FileStream(ruta, FileMode.Open, FileAccess.Read));
                    String fileLine = sr.ReadLine();
                    String[] fileData = fileLine.Split(',');
                    Parametros.RESOLUCION_W = Convert.ToInt32(fileData[0]);
                    Parametros.RESOLUCION_H = Convert.ToInt32(fileData[1]);
                    Parametros.FULLSCREEN = Convert.ToBoolean(fileData[2]);
                }
                catch (Exception)
                {
                }
                finally
                {
                    if ( sr != null ) sr.Close();
                }
            } 
            using (MainGame game = new MainGame())
            {
                game.Run();
            }
        }
    }
#endif
}

