﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework; 

namespace Game.Servicios
{
    class Contador
    {
        private int valor;
        public int Valor { get { return this.valor; } }
        
        private int lapso;
        private int rango;
        private int milisegundos;
        private int incremento; 

        public Contador(int _lapso, int _rango)
        {
            this.lapso = _lapso;
            this.rango = _rango;
            this.milisegundos = 0;
            this.valor = 0;
            this.incremento = +1; 
        }

        public void Update(GameTime gameTime)
        {
            milisegundos += gameTime.ElapsedGameTime.Milliseconds;
            if (milisegundos >= lapso)
            {
                milisegundos = milisegundos % lapso;
                valor+=incremento;
                if (valor == 0) incremento = +1;
                if (valor == rango)
                {
                    incremento = -1;
                    valor = rango - 1; 
                }
            }
        }

    }
}
