using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;


namespace Game.Servicios
{
    /// <summary>
    /// This is a game component that implements IUpdateable.
    /// </summary>
    public class ControlProcessor : AbstractProcessor
    {
        private struct Control
        {
            public Boolean valor; 
            public Boolean leido;

            public void Activar() {
                valor = true;
            }

            public void Desactivar() {
                valor = leido = false; 
            }

            public Boolean EstaActivo() {
                if (valor)
                {
                    if (!leido)
                    {
                        leido = true;
                        return valor;
                    }
                    else return false;
                }
                else return false; 
            }
        }

        private PlayerIndex player;

        private Control fondo;
        public Boolean Fondo { get { return fondo.EstaActivo(); } }
        private Control frente;
        public Boolean Frente { get { return frente.EstaActivo(); } }
        private Control izquierda;
        public Boolean Izquierda { get { return izquierda.EstaActivo(); } }
        private Control derecha;
        public Boolean Derecha { get { return derecha.EstaActivo(); } }
        private Control posar;
        public Boolean Posar { get { return posar.EstaActivo(); } }

        public Vector2 Vista; 

        public ControlProcessor(DefaultScene game, PlayerIndex _player)
            : base(game)
        {
            this.player = _player; 
            // TODO: Construct any child components here
        }

        /// <summary>
        /// Allows the game component to perform any initialization it needs to before starting
        /// to run.  This is where it can query for any required services and load content.
        /// </summary>
        public override void Initialize()
        {
        }

        public override void LoadContent()
        {
        }

        public override void UnloadContent()
        {
        }

        /// <summary>
        /// Allows the game component to update itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        public override void Update(GameTime gameTime)
        {
            // TODO: Add your update code here

            if (GamePad.GetState( this.player).IsConnected )
            {
                // Control PAD
                GamePadState pad = GamePad.GetState(this.player);
                Vista = pad.ThumbSticks.Left;
                Vista = Vector2.UnitX * ((pad.Triggers.Left) - (pad.Triggers.Right));
                if (pad.DPad.Up == ButtonState.Pressed) fondo.Activar(); else fondo.Desactivar();
                if (pad.DPad.Down == ButtonState.Pressed) frente.Activar(); else frente.Desactivar();
                if (pad.DPad.Left == ButtonState.Pressed) izquierda.Activar(); else izquierda.Desactivar();
                if (pad.DPad.Right == ButtonState.Pressed) derecha.Activar(); else derecha.Desactivar();
                if (pad.Buttons.A == ButtonState.Pressed) posar.Activar(); else posar.Desactivar();
            }
            else
            {
                // Control TECLADO
                KeyboardState keyboard = Keyboard.GetState();
                if (keyboard.IsKeyDown(Parametros.CONTROLES[(int)player, Parametros.ARRIBA])) fondo.Activar(); else fondo.Desactivar();
                if (keyboard.IsKeyDown(Parametros.CONTROLES[(int)player, Parametros.ABAJO])) frente.Activar(); else frente.Desactivar();
                if (keyboard.IsKeyDown(Parametros.CONTROLES[(int)player, Parametros.IZQUIERDA])) izquierda.Activar(); else izquierda.Desactivar();
                if (keyboard.IsKeyDown(Parametros.CONTROLES[(int)player, Parametros.DERECHA])) derecha.Activar(); else derecha.Desactivar();
                if (keyboard.IsKeyDown(Parametros.CONTROLES[(int)player, Parametros.DISPARO])) posar.Activar(); else posar.Desactivar();
                {
                    Vista = Vector2.Zero;
                    if (keyboard.IsKeyDown(Parametros.CONTROLES[(int)player, Parametros.GIRO_IZQUIERDA])) Vista.X = 1.0f;
                    if (keyboard.IsKeyDown(Parametros.CONTROLES[(int)player, Parametros.GIRO_DERECHA])) Vista.X = -1.0f;
                    if (keyboard.IsKeyDown(Keys.Up)) Vista.Y = +1.0f;
                    if (keyboard.IsKeyDown(Keys.Down)) Vista.Y = -1.0f;  
                }
            }
        }

        public override void Draw(GameTime gameTime)
        {
        }

    }
}
