﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework; 
using Microsoft.Xna.Framework.Graphics; 

namespace Core.Clases
{
    public class Grid
    {
        public VertexPositionColor[] vertex;
        public VertexBuffer vertexBuffer;

        public Grid( GraphicsDevice graphicsDevice)
        {
            List<VertexPositionColor> lvertex = new List<VertexPositionColor>();
            for (int y = -10; y <= 10; y++)
            {
                lvertex.Add(new VertexPositionColor(new Vector3(+10.0f, y, 0.0f), Color.Red));
                lvertex.Add(new VertexPositionColor(new Vector3(-10.0f, y, 0.0f), Color.Red));
            }
            for (int x = -10; x <= 10; x++)
            {
                lvertex.Add(new VertexPositionColor(new Vector3(x, +10.0f, 0.0f), Color.Cyan));
                lvertex.Add(new VertexPositionColor(new Vector3(x, -10.0f, 0.0f), Color.Cyan));
            }
            for (int z = -10; z <= 10; z++)
            {
                lvertex.Add(new VertexPositionColor(new Vector3(+10.0f, 0.0f, z), Color.Green));
                lvertex.Add(new VertexPositionColor(new Vector3(-10.0f, 0.0f, z), Color.Green));
            }
            for (int x = -10; x <= 10; x++)
            {
                lvertex.Add(new VertexPositionColor(new Vector3(x, 0.0f, +10.0f), Color.Cyan));
                lvertex.Add(new VertexPositionColor(new Vector3(x, 0.0f, -10.0f), Color.Cyan));
            }
            vertex = lvertex.ToArray<VertexPositionColor>();
            vertexBuffer = new VertexBuffer(graphicsDevice, typeof(VertexPositionColor), vertex.Length, BufferUsage.None);
            vertexBuffer.SetData(vertex);
        }
    }
}
