// Vertex shader input structure
struct VS_INPUT
{
    float4 Position   : POSITION;
    float4 Diffuse    : COLOR0;
};


// Vertex shader output structure
struct VS_OUTPUT
{
    float4 Position   : POSITION;
    float4 Diff       : COLOR0;
};


// Global variables
float4x4 WorldView;
float4x4 Proj;

VS_OUTPUT vs_main( in VS_INPUT In )
{
    VS_OUTPUT Out;
    float4 mvPos;                     //create an output vertex

    mvPos = mul(In.Position,
                       WorldView);  //apply vertex transformation

    Out.Position = mul(mvPos, Proj);

    Out.Diff = In.Diffuse;

    return Out;                         //return output vertex
}
