/*
 *		by JuhoAP 2011
 *
 *		Original particle code Was Created By Jeff Molofee 2000
 *		nehe.gamedev.net
 */
#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#include <windows.h>				// Header File For Windows
#include <stdint.h>
#include <stdlib.h>					// Header File For Standard Input/Output
#include <gl\gl.h>					// Header File For The OpenGL32 Library
#include <gl\glu.h>					// Header File For The GLu32 Library
#include <bassmod.h>

#define	MAX_PARTICLES	122880		// Number Of Particles To Create
#define XRES 1280					// x resolution of screen
#define YRES 720					// y resolution of screen
#define WNAME "epilomaniac by juhoap"		// window title

HDC			hDC=NULL;				// Private GDI Device Context
HGLRC		hRC=NULL;				// Permanent Rendering Context
HWND		hWnd=NULL;				// Holds Our Window Handle
HINSTANCE	hInstance;				// Holds The Instance Of The Application

// BASS
char modname[19] = "Data/demoraita3.xm";	// name of mod to play
int note1 = 0;						// which note was triggered? 0-119
int note2 = 0;						// which note was triggered? 0-119
int row = -1;						// which row was triggered?
int pat = -1;						// which pattern was triggered?
bool end = false;					// has the song ended?

int greetStart = 9;

bool	keys[256];					// Array Used For The Keyboard Routine
bool	active=TRUE;				// Window Active Flag Set To TRUE By Default
bool	fullscreen=TRUE;			// Fullscreen Flag Set To Fullscreen Mode By Default

float	slowdown=1.0f;				// Slow Down Particles
float	zoom=-100.0f;				// Used To Zoom Out
float	color = 1.0f;				// kytetn tekstin feidiss

GLuint	loop;						// Misc Loop Variable
GLuint	texture[14];				// Storage For Our Textures

typedef struct						// Create A Structure For Particle
{
	bool	active;					// Active (Yes/No)
	float	life;					// Particle Life
	float	fade;					// Fade Speed
	float	r;						// Red Value
	float	g;						// Green Value
	float	b;						// Blue Value
	float	x;						// X Position
	float	y;						// Y Position
	float	z;						// Z Position
	float	xi;						// X Direction
	float	yi;						// Y Direction
	float	zi;						// Z Direction
	float	xg;						// X Gravity
	float	yg;						// Y Gravity
	float	zg;						// Z Gravity
	int    smp;						// Instrument number the point belongs to
}
particles;							// Particles Structure

particles particle[MAX_PARTICLES];	// Particle Array (Room For Particle Info)

static GLfloat colors[12][3]=		// Rainbow Of Colors
{
	{1.0f,0.5f,0.5f},{1.0f,0.75f,0.5f},{1.0f,1.0f,0.5f},{0.75f,1.0f,0.5f},
	{0.5f,1.0f,0.5f},{0.5f,1.0f,0.75f},{0.5f,1.0f,1.0f},{0.5f,0.75f,1.0f},
	{0.5f,0.5f,1.0f},{0.75f,0.5f,1.0f},{1.0f,0.5f,1.0f},{1.0f,0.5f,0.75f}
};

bool triggerit[20];	// biisin instrumentit triggerein, 19kpl, eka (0) ei kytss

LRESULT	CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);	// Declaration For WndProc

// declaration of mod sync callback
void CALLBACK MySyncProc(HSYNC handle, DWORD data, DWORD user);
void CALLBACK SyncBD(HSYNC handle, DWORD data, DWORD user);
void CALLBACK SyncTang(HSYNC handle, DWORD data, DWORD user);
void CALLBACK SyncSD(HSYNC handle, DWORD data, DWORD user);
void CALLBACK SyncSynth1(HSYNC handle, DWORD data, DWORD user);
void CALLBACK SyncSynth2(HSYNC handle, DWORD data, DWORD user);
void CALLBACK SyncProc(HSYNC handle, DWORD data, DWORD user);
void CALLBACK SyncEnd(HSYNC handle, DWORD data, DWORD user);

bool NeHeLoadBitmap(LPTSTR szFileName, GLuint &texid)					// Creates Texture From A Bitmap File
{
	HBITMAP hBMP;														// Handle Of The Bitmap
	BITMAP	BMP;														// Bitmap Structure

	glGenTextures(1, &texid);											// Create The Texture
	hBMP=(HBITMAP)LoadImage(GetModuleHandle(NULL), szFileName, IMAGE_BITMAP, 0, 0, LR_CREATEDIBSECTION | LR_LOADFROMFILE );

	if (!hBMP)															// Does The Bitmap Exist?
		return FALSE;													// If Not Return False

	GetObject(hBMP, sizeof(BMP), &BMP);									// Get The Object
																		// hBMP:        Handle To Graphics Object
																		// sizeof(BMP): Size Of Buffer For Object Information
																		// &BMP:        Buffer For Object Information

	glPixelStorei(GL_UNPACK_ALIGNMENT, 4);								// Pixel Storage Mode (Word Alignment / 4 Bytes)

	// Typical Texture Generation Using Data From The Bitmap
	glBindTexture(GL_TEXTURE_2D, texid);								// Bind To The Texture ID
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);	// Linear Min Filter
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);	// Linear Mag Filter
	glTexImage2D(GL_TEXTURE_2D, 0, 3, BMP.bmWidth, BMP.bmHeight, 0, GL_BGR_EXT, GL_UNSIGNED_BYTE, BMP.bmBits);

	DeleteObject(hBMP);													// Delete The Object

	return TRUE;														// Loading Was Successful
}

GLvoid ReSizeGLScene(GLsizei width, GLsizei height)		// Resize And Initialize The GL Window
{
	if (height==0)										// Prevent A Divide By Zero By
	{
		height=1;										// Making Height Equal One
	}

	glViewport(0,0,width,height);						// Reset The Current Viewport

	glMatrixMode(GL_PROJECTION);						// Select The Projection Matrix
	glLoadIdentity();									// Reset The Projection Matrix

	// Calculate The Aspect Ratio Of The Window
	gluPerspective(55.0f,(GLfloat)width/(GLfloat)height,0.1f,100.0f);

	glMatrixMode(GL_MODELVIEW);							// Select The Modelview Matrix
	glLoadIdentity();									// Reset The Modelview Matrix
}

int InitGL(GLvoid)										// All Setup For OpenGL Goes Here
{
	if (!NeHeLoadBitmap("Data/Particle.bmp",texture[0])) { return FALSE; }
	if (!NeHeLoadBitmap("Data/epilomaniac.bmp",texture[1])) { return FALSE; }
	if (!NeHeLoadBitmap("Data/byjuhoap.bmp",texture[2])) { return FALSE; }
	if (!NeHeLoadBitmap("Data/ademofor.bmp",texture[3])) { return FALSE; }
	if (!NeHeLoadBitmap("Data/instanssi2011.bmp",texture[4])) { return FALSE; }

	if (!NeHeLoadBitmap("Data/black.bmp",texture[5])) { return FALSE; }

	if (!NeHeLoadBitmap("Data/greetz1.bmp",texture[6])) { return FALSE; }
	if (!NeHeLoadBitmap("Data/greetz2.bmp",texture[7])) { return FALSE; }
	if (!NeHeLoadBitmap("Data/greetz3.bmp",texture[8])) { return FALSE; }
	if (!NeHeLoadBitmap("Data/greetz4.bmp",texture[9])) { return FALSE; }
	if (!NeHeLoadBitmap("Data/greetz5.bmp",texture[10])) { return FALSE; }
	if (!NeHeLoadBitmap("Data/greetz6.bmp",texture[11])) { return FALSE; }
	if (!NeHeLoadBitmap("Data/greetz7.bmp",texture[12])) { return FALSE; }

	if (!NeHeLoadBitmap("Data/warning.bmp",texture[13])) { return FALSE; }

	glShadeModel(GL_SMOOTH);							// Enable Smooth Shading
	glClearColor(0.0f,0.0f,0.0f,0.0f);					// Black Background
	glClearDepth(1.0f);									// Depth Buffer Setup
	glDisable(GL_DEPTH_TEST);							// Disable Depth Testing
	glEnable(GL_BLEND);									// Enable Blending
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);					// Type Of Blending To Perform
	glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST);	// Really Nice Perspective Calculations
	glHint(GL_POINT_SMOOTH_HINT,GL_NICEST);				// Really Nice Point Smoothing
	glEnable(GL_TEXTURE_2D);							// Enable Texture Mapping

	// frozen particles
	// koita jotenki vaihdella nit x1,y1,z1 arvojen rajoja realtime!!
	float x1 = -75.0f;
	float y1 = -43.0f;
	float z1 = -30.0f;
	for (loop=0;loop<MAX_PARTICLES;loop++)						// Initializes All The Textures
	{
		particle[loop].active=true;								// Make All The Particles Active
		particle[loop].life=1.0f;								// Give All The Particles Full Life
		particle[loop].fade=0.1f;								// fade
		particle[loop].r=0.0f;									// r
		particle[loop].g=0.0f;									// g
		particle[loop].b=0.0f;									// b
		particle[loop].xi=0.0f;									// Speed On X Axis
		particle[loop].yi=0.0f;									// Speed On Y Axis
		particle[loop].zi=0.0f;									// Speed On Z Axis
		particle[loop].xg=0.0f;									// Set Horizontal Pull To Zero
		particle[loop].yg=0.0f;									// Set Vertical Pull To Zero
		particle[loop].zg=0.0f;									// Set Pull On Z Axis To Zero
		particle[loop].x=x1;									// Center On X Axis
		particle[loop].y=y1;									// Center On Y Axis
		particle[loop].z=z1;									// Center On Z Axis
		x1 += 1.0f;
		if (x1 > 75) { x1 = -75.0f; }
		y1 += 1.0f;
		if (y1 > 43) { y1 = -43.0f; }
		z1 += 1.0f;
		if (z1 > 30) { z1 = -30.0f; }

		// asetetaan sampleille alueet avaruudessa
		if ((x1>-9 && x1<9) && (y1>-7 && y1<7)) { particle[loop].smp = 1;}		// BD = keskusta
		else if ((x1>-22 && x1<22) && (y1>-16 && y1<16)) { particle[loop].smp = 3;}	// SD = keskustan ymprys
		else if (y1>15 || y1<-15) { particle[loop].smp = -1; }						// yl- ja alareunat
		else { particle[loop].smp = 0; }											// j sivureunat
	}

	for (int i=0; i<20; i++) {
		triggerit[i] = FALSE;
	}

	return TRUE;										// Initialization Went OK
}

int DrawGLScene(GLvoid)										// Here's Where We Do All The Drawing
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		// Clear Screen And Depth Buffer
	glLoadIdentity();										// Reset The ModelView Matrix

	glBindTexture(GL_TEXTURE_2D,texture[0]);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);

	for (loop=0;loop<MAX_PARTICLES;loop++)					// Loop Through All The Particles
	{
		if (particle[loop].active)							// If The Particle Is Active
		{
			float x=particle[loop].x;						// Grab Our Particle X Position
			float y=particle[loop].y;						// Grab Our Particle Y Position
			float z=particle[loop].z+zoom;					// Particle Z Pos + Zoom

			// Draw The Particle Using Our RGB Values, Fade The Particle Based On It's Life
			glColor4f(particle[loop].r,particle[loop].g,particle[loop].b,particle[loop].life);
			glBegin(GL_TRIANGLE_STRIP);						// Build Quad From A Triangle Strip
			    glTexCoord2d(1,1); glVertex3f(x+0.75f+particle[loop].xi/(slowdown*100),y+0.75f+particle[loop].yi/(slowdown*100),z); // Top Right
				glTexCoord2d(0,1); glVertex3f(x-0.75f+particle[loop].xi/(slowdown*100),y+0.75f+particle[loop].yi/(slowdown*100),z); // Top Left
				glTexCoord2d(1,0); glVertex3f(x+0.75f+particle[loop].xi/(slowdown*100),y-0.75f+particle[loop].yi/(slowdown*100),z); // Bottom Right
				glTexCoord2d(0,0); glVertex3f(x-0.75f+particle[loop].xi/(slowdown*100),y-0.75f+particle[loop].yi/(slowdown*100),z); // Bottom Left
			glEnd();										// Done Building Triangle Strip

			particle[loop].xi+=particle[loop].xg;			// Take Pull On X Axis Into Account
			particle[loop].yi+=particle[loop].yg;			// Take Pull On Y Axis Into Account
			particle[loop].zi+=particle[loop].zg;			// Take Pull On Z Axis Into Account
			
			// PARTICLE LIFE
			particle[loop].life-=particle[loop].fade;		// Reduce Particles Life By 'Fade'

			// SYNCING
			if (triggerit[18])
			{
				if (particle[loop].smp == 0 && pat>7)
				{
					particle[loop].life=0.5f;							// Give It New Life
					particle[loop].r=colors[(note1%12)][0];			// Select Red From Color Table
					particle[loop].g=colors[(note1%12)][1];			// Select Green From Color Table
					particle[loop].b=colors[(note1%12)][2];			// Select Blue From Color Table
					particle[loop].xi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On X Axis
					particle[loop].yi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On Y Axis
					particle[loop].zi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On Z Axis
					particle[loop].xg=float(rand()%64)-32;				// Set Horizontal Pull To Zero
					particle[loop].yg=float(rand()%64)-32;				// Set Vertical Pull To Zero
					particle[loop].zg=float(rand()%64)-32;				// Set Pull On Z Axis To Zero
					zoom=-100.0f+rand()%100;
				}
				else if (particle[loop].smp == -1 && pat>7)
				{
					particle[loop].life=0.5f;							// Give It New Life
					particle[loop].r=colors[(note1%12)][0];			// Select Red From Color Table
					particle[loop].g=colors[(note1%12)][1];			// Select Green From Color Table
					particle[loop].b=colors[(note1%12)][2];			// Select Blue From Color Table
					particle[loop].xi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On X Axis
					particle[loop].yi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On Y Axis
					particle[loop].zi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On Z Axis
					particle[loop].xg=float(rand()%64)-32;				// Set Horizontal Pull To Zero
					particle[loop].yg=float(rand()%64)-32;				// Set Vertical Pull To Zero
					particle[loop].zg=float(rand()%64)-32;				// Set Pull On Z Axis To Zero
					zoom=-100.0f+rand()%100;
				}
			}
			
			if (triggerit[19])
			{
				if (particle[loop].smp == -1 && pat<3)
				{
					particle[loop].life=1.0f;							// Give It New Life
					particle[loop].r=colors[(note2%12)][0];			// Select Red From Color Table
					particle[loop].g=colors[(note2%12)][1];			// Select Green From Color Table
					particle[loop].b=colors[(note2%12)][2];			// Select Blue From Color Table
					particle[loop].xi=float((rand()%50)-25.0f)*1.0f;	// Random Speed On X Axis
					particle[loop].yi=float((rand()%50)-25.0f)*1.0f;	// Random Speed On Y Axis
					particle[loop].zi=float((rand()%50)-25.0f)*1.0f;	// Random Speed On Z Axis
					particle[loop].xg=0.0f;				// Set Horizontal Pull To Zero
					if (y>0) particle[loop].yg=-16.0f;
					else particle[loop].yg=16.0f;
					particle[loop].zg=0.0f;				// Set Pull On Z Axis To Zero
				}
				else if (particle[loop].smp == -1 && pat>7)
				{
					particle[loop].life=0.5f;							// Give It New Life
					particle[loop].r=colors[(note2%12)][0];			// Select Red From Color Table
					particle[loop].g=colors[(note2%12)][1];			// Select Green From Color Table
					particle[loop].b=colors[(note2%12)][2];			// Select Blue From Color Table
					particle[loop].xi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On X Axis
					particle[loop].yi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On Y Axis
					particle[loop].zi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On Z Axis
					particle[loop].xg=float(rand()%64)-32;				// Set Horizontal Pull To Zero
					particle[loop].yg=float(rand()%64)-32;				// Set Vertical Pull To Zero
					particle[loop].zg=float(rand()%64)-32;				// Set Pull On Z Axis To Zero
					zoom=-100.0f+rand()%100;
				}
			}
			
			if (triggerit[3])
			{
				if (particle[loop].smp == 3 && pat>2)
				{
					particle[loop].life=1.75f;							// Give It New Life
					particle[loop].r=colors[1-(rand()%12)][0];			// Select Red From Color Table
					particle[loop].g=colors[1-(rand()%12)][1];			// Select Green From Color Table
					particle[loop].b=colors[1-(rand()%12)][2];			// Select Blue From Color Table
					particle[loop].xi=float((rand()%50)-25.0f)*1.0f;	// Random Speed On X Axis
					particle[loop].yi=float((rand()%50)-25.0f)*1.0f;	// Random Speed On Y Axis
					particle[loop].zi=float((rand()%50)-25.0f)*1.0f;	// Random Speed On Z Axis
					particle[loop].xg=float(rand()%32)-16;				// Set Horizontal Pull To Zero
					particle[loop].yg=float(rand()%32)-16;				// Set Vertical Pull To Zero
					particle[loop].zg=float(rand()%32)-16;				// Set Pull On Z Axis To Zero
				}
			}

			if (triggerit[1])
			{
				if (particle[loop].smp == 1 && pat>2)
				{
					particle[loop].life=1.0f;							// Give It New Life
					particle[loop].r=colors[(rand()%12)][0];			// Select Red From Color Table
					particle[loop].g=colors[(rand()%12)][1];			// Select Green From Color Table
					particle[loop].b=colors[(rand()%12)][2];			// Select Blue From Color Table
					particle[loop].xi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On X Axis
					particle[loop].yi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On Y Axis
					particle[loop].zi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On Z Axis
					particle[loop].xg=float(rand()%6)-3;				// Set Horizontal Pull To Zero
					particle[loop].yg=float(rand()%6)-3;				// Set Vertical Pull To Zero
					particle[loop].zg=float(rand()%6)-3;				// Set Pull On Z Axis To Zero
					zoom=-100.0f+rand()%75;
				}
				else if (particle[loop].smp == -1 && pat<3)
				{
					particle[loop].life=1.0f;							// Give It New Life
					particle[loop].r=colors[(rand()%12)][0];			// Select Red From Color Table
					particle[loop].g=colors[(rand()%12)][1];			// Select Green From Color Table
					particle[loop].b=colors[(rand()%12)][2];			// Select Blue From Color Table
					particle[loop].xi=float((rand()%50)-25.0f)*1.0f;	// Random Speed On X Axis
					particle[loop].yi=float((rand()%50)-25.0f)*1.0f;	// Random Speed On Y Axis
					particle[loop].zi=float((rand()%50)-25.0f)*1.0f;	// Random Speed On Z Axis
					particle[loop].xg=0.0f;				// Set Horizontal Pull To Zero
					if (y>0) particle[loop].yg=-16.0f;
					else particle[loop].yg=16.0f;
					particle[loop].zg=0.0f;				// Set Pull On Z Axis To Zero
				}
			}

			if (triggerit[2])
			{
				if ((particle[loop].smp == 0 || particle[loop].smp == 1 || particle[loop].smp == -1) && (pat<6 && pat>2))
				{
					particle[loop].life=1.5f;							// Give It New Life

					particle[loop].xi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On X Axis
					particle[loop].yi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On Y Axis
					particle[loop].zi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On Z Axis

					if (x>20) { particle[loop].xg=128.0f; }
					else if (x<-20) { particle[loop].xg=-128.0f; }

					if (y>10)
					{
						particle[loop].yg=128.0f;
						particle[loop].r=colors[(rand()%12)][0];
						particle[loop].g=colors[(rand()%12)][1];
						particle[loop].b=colors[(rand()%12)][2];
					}
					else if (y<-10)
					{
						particle[loop].yg=-128.0f;
						particle[loop].r=1.0f-colors[(rand()%12)][0];
						particle[loop].g=1.0f-colors[(rand()%12)][1];
						particle[loop].b=1.0f-colors[(rand()%12)][2];
					}
					particle[loop].zg=float(rand()%64)-32;				// Set Pull On Z Axis To Zero
				}
				else if ((particle[loop].smp == -1 || particle[loop].smp == 0) && pat>5)
				{
					particle[loop].life=0.5f;							// Give It New Life
					particle[loop].r=colors[(rand()%12)][0];			// Select Red From Color Table
					particle[loop].g=colors[(rand()%12)][1];			// Select Green From Color Table
					particle[loop].b=colors[(rand()%12)][2];			// Select Blue From Color Table
					particle[loop].xi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On X Axis
					particle[loop].yi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On Y Axis
					particle[loop].zi=float((rand()%50)-25.0f)*10.0f;	// Random Speed On Z Axis
					particle[loop].xg=float(rand()%6)-3;				// Set Horizontal Pull To Zero
					particle[loop].yg=float(rand()%6)-3;
					particle[loop].zg=float(rand()%6)-3;				// Set Pull On Z Axis To Zero
				}
			}
		}
    }
	
	// kuvat ruudulle
	float x = 0.0f;
	float y = 3.0f;
	float z = -100.0f;
	glColor4f(1.0f,1.0f,1.0f,1.0f);	// vrit iha tysii!!1
	glBlendFunc(GL_ONE,GL_ZERO);	// ei blendailla

	// DEMO NAME PART
	if (pat>0 && pat<3)	// demon nimi
	{
		if (pat == 2 && row == 48)	// feidi varten
		{
			glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_DST_COLOR);
		}
		glColor4f(color,color,color,color);
		glBindTexture(GL_TEXTURE_2D,texture[1]);	// nimi
		glBegin(GL_TRIANGLE_STRIP);
			glTexCoord2d(1,1); glVertex3f(x+56.0f,y+9.0f,z);
			glTexCoord2d(0,1); glVertex3f(x-56.0f,y+9.0f,z);
			glTexCoord2d(1,0); glVertex3f(x+56.0f,y-9.0f,z);
			glTexCoord2d(0,0); glVertex3f(x-56.0f,y-9.0f,z);
		glEnd();

		if (pat == 1 && row == 0)	// by juhoap
		{
			y -= 13.3f;
			glBindTexture(GL_TEXTURE_2D,texture[2]);
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+56.0f,y+4.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-56.0f,y+4.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+56.0f,y-4.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-56.0f,y-4.0f,z);
			glEnd();
		}
		else if (pat == 2 && row == 0)	// a demo for
		{
			y -= 13.3f;
			glBindTexture(GL_TEXTURE_2D,texture[3]);
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+56.0f,y+4.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-56.0f,y+4.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+56.0f,y-4.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-56.0f,y-4.0f,z);
			glEnd();
		}
		else if (pat == 2 && row == 32)	// instanssi 2011
		{
			y -= 13.3f;
			glBindTexture(GL_TEXTURE_2D,texture[4]);
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+56.0f,y+4.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-56.0f,y+4.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+56.0f,y-4.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-56.0f,y-4.0f,z);
			glEnd();
		}
		else if (pat == 2 && row == 48)	// instanssi 2011 fade
		{
			y -= 13.3f;
			color -= 0.01f;
			glBindTexture(GL_TEXTURE_2D,texture[4]);
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+56.0f,y+4.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-56.0f,y+4.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+56.0f,y-4.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-56.0f,y-4.0f,z);
			glEnd();
		}
	}

	// HAZARD!
	else if (pat==3)
	{
		y = 0;
		int r = row%4;
		float zr = z+((4-(row%4))*18);
		glColor4f(1.0f,1.0f,1.0f,1.0f-(r*0.25f));
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_DST_COLOR);
		glBindTexture(GL_TEXTURE_2D,texture[13]);
		glBegin(GL_TRIANGLE_STRIP);
			glTexCoord2d(1,1); glVertex3f(x+10.0f,y+12.0f,zr);
			glTexCoord2d(0,1); glVertex3f(x-10.0f,y+12.0f,zr);
			glTexCoord2d(1,0); glVertex3f(x+10.0f,y-12.0f,zr);
			glTexCoord2d(0,0); glVertex3f(x-10.0f,y-12.0f,zr);
		glEnd();
	}
	
	else
	{

		// GREETINGS PART
		if (pat == greetStart && row == 0)
		{
			y = 3.0f;
			glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_DST_COLOR);		// blendataan et mustasta nkyy lpi
			glBindTexture(GL_TEXTURE_2D,texture[5]);				// musta tausta
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+100.0f,y+50.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-100.0f,y+50.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+100.0f,y-55.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-100.0f,y-55.0f,z);
			glEnd();
			y = 0.0f;
			glBindTexture(GL_TEXTURE_2D,texture[6]);				// greetz
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+18.0f,y+5.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-18.0f,y+5.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+18.0f,y-5.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-18.0f,y-5.0f,z);
			glEnd();
		}
		else if (pat == greetStart && row == 16)
		{
			y = 3.0f;
			glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_DST_COLOR);
			glBindTexture(GL_TEXTURE_2D,texture[5]);
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+100.0f,y+50.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-100.0f,y+50.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+100.0f,y-55.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-100.0f,y-55.0f,z);
			glEnd();
			y = 0.0f;
			glBindTexture(GL_TEXTURE_2D,texture[7]);				// to
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+7.0f,y+5.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-7.0f,y+5.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+7.0f,y-5.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-7.0f,y-5.0f,z);
			glEnd();
		}
		else if (pat == greetStart && row == 32)
		{
			y = 3.0f;
			glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_DST_COLOR);
			glBindTexture(GL_TEXTURE_2D,texture[5]);
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+100.0f,y+50.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-100.0f,y+50.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+100.0f,y-55.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-100.0f,y-55.0f,z);
			glEnd();
			y = 0.0f;
			glBindTexture(GL_TEXTURE_2D,texture[8]);				// AP
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+44.0f,y+5.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-44.0f,y+5.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+44.0f,y-5.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-44.0f,y-5.0f,z);
			glEnd();
		}
		else if (pat == greetStart && row == 48)
		{
			y = 3.0f;
			glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_DST_COLOR);
			glBindTexture(GL_TEXTURE_2D,texture[5]);
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+100.0f,y+50.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-100.0f,y+50.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+100.0f,y-55.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-100.0f,y-55.0f,z);
			glEnd();
			y = 0.0f;
			glBindTexture(GL_TEXTURE_2D,texture[9]);				// CUBICLE
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+19.0f,y+5.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-19.0f,y+5.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+19.0f,y-5.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-19.0f,y-5.0f,z);
			glEnd();
		}
		else if ((pat == (greetStart+1)) && row == 0)
		{
			y = 3.0f;
			glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_DST_COLOR);
			glBindTexture(GL_TEXTURE_2D,texture[5]);
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+100.0f,y+50.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-100.0f,y+50.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+100.0f,y-55.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-100.0f,y-55.0f,z);
			glEnd();
			y = 0.0f;
			glBindTexture(GL_TEXTURE_2D,texture[10]);				// INSTANSSI
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+24.0f,y+5.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-24.0f,y+5.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+24.0f,y-5.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-24.0f,y-5.0f,z);
			glEnd();
		}
		else if ((pat == (greetStart+1)) && row == 16)
		{
			y = 3.0f;
			glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_DST_COLOR);
			glBindTexture(GL_TEXTURE_2D,texture[5]);
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+100.0f,y+50.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-100.0f,y+50.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+100.0f,y-55.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-100.0f,y-55.0f,z);
			glEnd();
			y = 0.0f;
			glBindTexture(GL_TEXTURE_2D,texture[11]);				// KULTA
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+15.0f,y+5.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-15.0f,y+5.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+15.0f,y-5.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-15.0f,y-5.0f,z);
			glEnd();
		}
		else if ((pat == (greetStart+1)) && row == 32)
		{
			y = 3.0f;
			glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_DST_COLOR);
			glBindTexture(GL_TEXTURE_2D,texture[5]);
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+100.0f,y+50.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-100.0f,y+50.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+100.0f,y-55.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-100.0f,y-55.0f,z);
			glEnd();
			y = 0.0f;
			glBindTexture(GL_TEXTURE_2D,texture[12]);				// YOU
			glBegin(GL_TRIANGLE_STRIP);
				glTexCoord2d(1,1); glVertex3f(x+10.0f,y+5.0f,z);
				glTexCoord2d(0,1); glVertex3f(x-10.0f,y+5.0f,z);
				glTexCoord2d(1,0); glVertex3f(x+10.0f,y-5.0f,z);
				glTexCoord2d(0,0); glVertex3f(x-10.0f,y-5.0f,z);
			glEnd();
		}
	}
	
	if (pat==17 && row==16) { end = TRUE; }					// lopetuskohta biisiss

	for (int i=0; i<20; i++)  triggerit[i] = FALSE;			// nollataan triggerit (vh glitchaa vlill mut watevah)
	return true;											// Everything Went OK
}

GLvoid KillGLWindow(GLvoid)								// Properly Kill The Window
{
	if (fullscreen)										// Are We In Fullscreen Mode?
	{
		ChangeDisplaySettings(NULL,0);					// If So Switch Back To The Desktop
		ShowCursor(TRUE);								// Show Mouse Pointer
	}

	if (hRC)											// Do We Have A Rendering Context?
	{
		if (!wglMakeCurrent(NULL,NULL))					// Are We Able To Release The DC And RC Contexts?
		{
			MessageBox(NULL,"Release Of DC And RC Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		}

		if (!wglDeleteContext(hRC))						// Are We Able To Delete The RC?
		{
			MessageBox(NULL,"Release Rendering Context Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		}
		hRC=NULL;										// Set RC To NULL
	}

	if (hDC && !ReleaseDC(hWnd,hDC))					// Are We Able To Release The DC
	{
		MessageBox(NULL,"Release Device Context Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		hDC=NULL;										// Set DC To NULL
	}

	if (hWnd && !DestroyWindow(hWnd))					// Are We Able To Destroy The Window?
	{
		MessageBox(NULL,"Could Not Release hWnd.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		hWnd=NULL;										// Set hWnd To NULL
	}

	if (!UnregisterClass("OpenGL",hInstance))			// Are We Able To Unregister Class
	{
		MessageBox(NULL,"Could Not Unregister Class.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
		hInstance=NULL;									// Set hInstance To NULL
	}
}

/*	This Code Creates Our OpenGL Window.  Parameters Are:					*
 *	title			- Title To Appear At The Top Of The Window				*
 *	width			- Width Of The GL Window Or Fullscreen Mode				*
 *	height			- Height Of The GL Window Or Fullscreen Mode			*
 *	bits			- Number Of Bits To Use For Color (8/16/24/32)			*
 *	fullscreenflag	- Use Fullscreen Mode (TRUE) Or Windowed Mode (FALSE)	*/
 
BOOL CreateGLWindow(char* title, int width, int height, int bits, bool fullscreenflag)
{
	GLuint		PixelFormat;			// Holds The Results After Searching For A Match
	WNDCLASS	wc;						// Windows Class Structure
	DWORD		dwExStyle;				// Window Extended Style
	DWORD		dwStyle;				// Window Style
	RECT		WindowRect;				// Grabs Rectangle Upper Left / Lower Right Values
	WindowRect.left=(long)0;			// Set Left Value To 0
	WindowRect.right=(long)width;		// Set Right Value To Requested Width
	WindowRect.top=(long)0;				// Set Top Value To 0
	WindowRect.bottom=(long)height;		// Set Bottom Value To Requested Height

	fullscreen=fullscreenflag;			// Set The Global Fullscreen Flag

	hInstance			= GetModuleHandle(NULL);				// Grab An Instance For Our Window
	wc.style			= CS_HREDRAW | CS_VREDRAW | CS_OWNDC;	// Redraw On Size, And Own DC For Window.
	wc.lpfnWndProc		= (WNDPROC) WndProc;					// WndProc Handles Messages
	wc.cbClsExtra		= 0;									// No Extra Window Data
	wc.cbWndExtra		= 0;									// No Extra Window Data
	wc.hInstance		= hInstance;							// Set The Instance
	wc.hIcon			= LoadIcon(NULL, IDI_WINLOGO);			// Load The Default Icon
	wc.hCursor			= LoadCursor(NULL, IDC_ARROW);			// Load The Arrow Pointer
	wc.hbrBackground	= NULL;									// No Background Required For GL
	wc.lpszMenuName		= NULL;									// We Don't Want A Menu
	wc.lpszClassName	= "OpenGL";								// Set The Class Name

	if (!RegisterClass(&wc))									// Attempt To Register The Window Class
	{
		MessageBox(NULL,"Failed To Register The Window Class.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;											// Return FALSE
	}
	
	if (fullscreen)												// Attempt Fullscreen Mode?
	{
		DEVMODE dmScreenSettings;								// Device Mode
		//memset(&dmScreenSettings,0,sizeof(dmScreenSettings));	// Makes Sure Memory's Cleared
		dmScreenSettings.dmSize=sizeof(dmScreenSettings);		// Size Of The Devmode Structure
		dmScreenSettings.dmPelsWidth	= width;				// Selected Screen Width
		dmScreenSettings.dmPelsHeight	= height;				// Selected Screen Height
		dmScreenSettings.dmBitsPerPel	= bits;					// Selected Bits Per Pixel
		dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;

		// Try To Set Selected Mode And Get Results.  NOTE: CDS_FULLSCREEN Gets Rid Of Start Bar.
		if (ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL)
		{
			// If The Mode Fails, Offer Two Options.  Quit Or Use Windowed Mode.
			if (MessageBox(NULL,"The Requested Fullscreen Mode Is Not Supported By\nYour Video Card. Use Windowed Mode Instead?","Ooops..",MB_YESNO|MB_ICONEXCLAMATION)==IDYES)
			{
				fullscreen=FALSE;		// Windowed Mode Selected.  Fullscreen = FALSE
			}
			else
			{
				// Pop Up A Message Box Letting User Know The Program Is Closing.
				MessageBox(NULL,"Program Will Now Close.","ERROR",MB_OK|MB_ICONSTOP);
				return FALSE;									// Return FALSE
			}
		}
	}

	if (fullscreen)												// Are We Still In Fullscreen Mode?
	{
		dwExStyle=WS_EX_APPWINDOW;								// Window Extended Style
		dwStyle=WS_POPUP;										// Windows Style
		ShowCursor(FALSE);										// Hide Mouse Pointer
	}
	else
	{
		dwExStyle=WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;			// Window Extended Style
		dwStyle=WS_OVERLAPPEDWINDOW;							// Windows Style
	}

	AdjustWindowRectEx(&WindowRect, dwStyle, FALSE, dwExStyle);		// Adjust Window To True Requested Size

	// Create The Window
	if (!(hWnd=CreateWindowEx(	dwExStyle,							// Extended Style For The Window
								"OpenGL",							// Class Name
								title,								// Window Title
								dwStyle |							// Defined Window Style
								WS_CLIPSIBLINGS |					// Required Window Style
								WS_CLIPCHILDREN,					// Required Window Style
								0, 0,								// Window Position
								WindowRect.right-WindowRect.left,	// Calculate Window Width
								WindowRect.bottom-WindowRect.top,	// Calculate Window Height
								NULL,								// No Parent Window
								NULL,								// No Menu
								hInstance,							// Instance
								NULL)))								// Dont Pass Anything To WM_CREATE
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Window Creation Error.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	static	PIXELFORMATDESCRIPTOR pfd=				// pfd Tells Windows How We Want Things To Be
	{
		sizeof(PIXELFORMATDESCRIPTOR),				// Size Of This Pixel Format Descriptor
		1,											// Version Number
		PFD_DRAW_TO_WINDOW |						// Format Must Support Window
		PFD_SUPPORT_OPENGL |						// Format Must Support OpenGL
		PFD_DOUBLEBUFFER,							// Must Support Double Buffering
		PFD_TYPE_RGBA,								// Request An RGBA Format
		bits,										// Select Our Color Depth
		0, 0, 0, 0, 0, 0,							// Color Bits Ignored
		0,											// No Alpha Buffer
		0,											// Shift Bit Ignored
		0,											// No Accumulation Buffer
		0, 0, 0, 0,									// Accumulation Bits Ignored
		16,											// 16Bit Z-Buffer (Depth Buffer)  
		0,											// No Stencil Buffer
		0,											// No Auxiliary Buffer
		PFD_MAIN_PLANE,								// Main Drawing Layer
		0,											// Reserved
		0, 0, 0										// Layer Masks Ignored
	};
	
	if (!(hDC=GetDC(hWnd)))							// Did We Get A Device Context?
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Create A GL Device Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if (!(PixelFormat=ChoosePixelFormat(hDC,&pfd)))	// Did Windows Find A Matching Pixel Format?
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Find A Suitable PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if(!SetPixelFormat(hDC,PixelFormat,&pfd))		// Are We Able To Set The Pixel Format?
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Set The PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if (!(hRC=wglCreateContext(hDC)))				// Are We Able To Get A Rendering Context?
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Create A GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if(!wglMakeCurrent(hDC,hRC))					// Try To Activate The Rendering Context
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Activate The GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	ShowWindow(hWnd,SW_SHOW);						// Show The Window
	SetForegroundWindow(hWnd);						// Slightly Higher Priority
	SetFocus(hWnd);									// Sets Keyboard Focus To The Window
	ReSizeGLScene(width, height);					// Set Up Our Perspective GL Screen

	if (!InitGL())									// Initialize Our Newly Created GL Window
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Initialization Failed.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	return TRUE;									// Success
}

LRESULT CALLBACK WndProc(	HWND	hWnd,			// Handle For This Window
							UINT	uMsg,			// Message For This Window
							WPARAM	wParam,			// Additional Message Information
							LPARAM	lParam)			// Additional Message Information
{
	switch (uMsg)									// Check For Windows Messages
	{
		case WM_ACTIVATE:							// Watch For Window Activate Message
		{
			if (!HIWORD(wParam))					// Check Minimization State
			{
				active=TRUE;						// Program Is Active
			}
			else									// Otherwise
			{
				active=FALSE;						// Program Is No Longer Active
			}

			return 0;								// Return To The Message Loop
		}

		case WM_SYSCOMMAND:							// Intercept System Commands
		{
			switch (wParam)							// Check System Calls
			{
				case SC_SCREENSAVE:					// Screensaver Trying To Start?
				case SC_MONITORPOWER:				// Monitor Trying To Enter Powersave?
				return 0;							// Prevent From Happening
			}
			break;									// Exit
		}

		case WM_CLOSE:								// Did We Receive A Close Message?
		{
			PostQuitMessage(0);						// Send A Quit Message
			return 0;								// Jump Back
		}

		case WM_KEYDOWN:							// Is A Key Being Held Down?
		{
			keys[wParam] = TRUE;					// If So, Mark It As TRUE
			return 0;								// Jump Back
		}

		case WM_KEYUP:								// Has A Key Been Released?
		{
			keys[wParam] = FALSE;					// If So, Mark It As FALSE
			return 0;								// Jump Back
		}

		case WM_SIZE:								// Resize The OpenGL Window
		{
			ReSizeGLScene(LOWORD(lParam),HIWORD(lParam));  // LoWord=Width, HiWord=Height
			return 0;								// Jump Back
		}
	}

	// Pass All Unhandled Messages To DefWindowProc
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}

int WINAPI WinMain(	HINSTANCE	hInstance,			// Instance
					HINSTANCE	hPrevInstance,		// Previous Instance
					LPSTR		lpCmdLine,			// Command Line Parameters
					int			nCmdShow)			// Window Show State
{
	MSG		msg;									// Windows Message Structure
	BOOL	done=FALSE;								// Bool Variable To Exit Loop

	// Ask The User Which Screen Mode They Prefer
	if (MessageBox(NULL,"Would You Like To Run In Fullscreen Mode?", "Start FullScreen?",MB_YESNO|MB_ICONQUESTION)==IDNO)
	{
		fullscreen=FALSE;							// Windowed Mode
	}

	// Create Our OpenGL Window
	if (!CreateGLWindow(WNAME,XRES,YRES,32,fullscreen))
	{
		return 0;									// Quit If Window Was Not Created
	}

	if (fullscreen)									// Are We In Fullscreen Mode
	{
		slowdown=1.0f;								// If So, Speed Up The Particles (3dfx Issue)
	}

	////////////////////////////////////////////////////////
	///////////////////// BASS!! ///////////////////////////
	////////////////////////////////////////////////////////
	if (!BASSMOD_Init(-1,44100,0)) { done=TRUE; }	// initialize default output device
	if (!BASSMOD_MusicLoad(FALSE,modname,0,0,BASS_MUSIC_RAMPS|BASS_MUSIC_SURROUND)) { done=TRUE; }
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(-1,0), &MySyncProc, 0);

	BASSMOD_MusicSetSync(BASS_SYNC_MUSICINST, MAKELONG(1,-1), &SyncBD, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_MUSICINST, MAKELONG(2,-1), &SyncTang, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_MUSICINST, MAKELONG(3,-1), &SyncSD, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_MUSICINST, MAKELONG(18,-1), &SyncSynth1, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_MUSICINST, MAKELONG(19,-1), &SyncSynth2, 0);

	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(1,0), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(2,0), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(2,32), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(2,48), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(3,-1), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(greetStart,0), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(greetStart,8), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(greetStart,16), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(greetStart,24), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(greetStart,32), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(greetStart,40), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(greetStart,48), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(greetStart,56), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(greetStart+1,0), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(greetStart+1,8), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(greetStart+1,16), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(greetStart+1,24), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(greetStart+1,32), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(greetStart+1,48), &SyncProc, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS, MAKELONG(17,16), &SyncProc, 0);

	BASSMOD_MusicSetSync(BASS_SYNC_END, 0, &SyncEnd, 0);

	if (!BASSMOD_MusicPlay()) {	done=TRUE; }
	////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////

	while(!done)									// Loop That Runs While done=FALSE
	{
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))	// Is There A Message Waiting?
		{
			if (msg.message==WM_QUIT)				// Have We Received A Quit Message?
			{
				done=TRUE;							// If So done=TRUE
			}
			else									// If Not, Deal With Window Messages
			{
				TranslateMessage(&msg);				// Translate The Message
				DispatchMessage(&msg);				// Dispatch The Message
			}
		}
		else										// If There Are No Messages
		{
			// Draw The Scene.  Watch For ESC Key And Quit Messages From DrawGLScene()
			if ((active && !DrawGLScene()) || keys[VK_ESCAPE])	// Active?  Was There A Quit Received?
			{
				done=TRUE;							// ESC or DrawGLScene Signalled A Quit
			}
			else									// Not Time To Quit, Update Screen
			{
				SwapBuffers(hDC);					// Swap Buffers (Double Buffering)
				if (end) { done = TRUE; }				// reached end of song?
			}
		}
	}

	// Shutdown
	BASSMOD_Free();
	KillGLWindow();									// Kill The Window
	if (msg.wParam)
	{
		return (msg.wParam);							// Exit The Program
	}
	else
	{
		return 0;
	}

}

void CALLBACK MySyncProc(HSYNC handle, DWORD data, DWORD user) {
	if (pat != LOWORD(data))
	{
		pat = LOWORD(data);
	}
}

void CALLBACK SyncBD(HSYNC handle, DWORD data, DWORD user)
{
	triggerit[1] = true;
}
void CALLBACK SyncTang(HSYNC handle, DWORD data, DWORD user)
{
	triggerit[2] = true;
}
void CALLBACK SyncSD(HSYNC handle, DWORD data, DWORD user)
{
	triggerit[3] = true;
}
void CALLBACK SyncSynth1(HSYNC handle, DWORD data, DWORD user)
{
	triggerit[18] = true;
	note1 = LOWORD(data);
}
void CALLBACK SyncSynth2(HSYNC handle, DWORD data, DWORD user)
{
	triggerit[19] = true;
	note2 = LOWORD(data);
}
void CALLBACK SyncProc(HSYNC handle, DWORD data, DWORD user)
{
	pat = LOWORD(data);
	row = HIWORD(data);
}
void CALLBACK SyncEnd(HSYNC handle, DWORD data, DWORD user)
{
	end=TRUE;
}
