package Ragedemo01;

import processing.core.PApplet;
import processing.core.PImage;

/**
 * A class for bouncing images on the screen.
 * 
 * @author RageManifesto
 * @version 001
 *
 */
public class RageCuteAnimal extends PApplet {
	
	private PApplet parent;
	private float posX = 0f;
	private float posY = 0f;
	private float baseHeight;
	private float speed_x;
	private float speed_jump;
	private PImage cuteImg;
	private float sinInput = 0f;
	private float sinOutput = 0f;
	private float scaleY;


	RageCuteAnimal(PApplet p,
			String imgPath,
			float spawnX,
			float spawnY,
			float speed,
			float jumpSpeed) {
			
		this.parent = p;		
		this.cuteImg = p.loadImage(imgPath);		
		this.posX = spawnX;
		this.posY = spawnY;
		this.baseHeight = spawnY;
		this.speed_x = speed;
		this.speed_jump = jumpSpeed;
		
		this.sinInput = parent.random(0.0f, 1.0f);
	}
	
	
	
	
	public void draw() {
		
		posX += speed_x;
		
		sinInput += 0.10f * speed_jump;
		sinOutput = (float) -Math.abs(Math.sin(sinInput));
		//System.out.println(sinOutput);
		
		posY = (float) (baseHeight + sinOutput*400);
		scaleY = (float)(1 + sinOutput/3);
		
		parent.pushMatrix();
		
		//parent.imageMode(CORNERS);
		parent.scale(1.0f, scaleY);
		parent.image(cuteImg, posX, posY);
		
		parent.popMatrix();
		
		
	}
	
	
}
