package Ragedemo01;

import processing.core.*;

/**
 * A simple class for some textured cube fun.
 * A lot of the implementation is from the Processing example
 * "TextureCube".
 * 
 * 
 * @author RageManifesto
 * @version 001
 *
 */
public class RageHelloBox extends PApplet {
	
	private PApplet parent;
	private PImage texture1;
	private float rotx, roty, rotz;
	private float rotInput = 0f;
	private float posx;
	private float posy;
	private float rotVariation;
	
	RageHelloBox(PApplet p, String tex1path, float xpos, float ypos, float rotationVariation) {
		
		this.parent = p;
		this.texture1 = p.loadImage(tex1path);
		this.posx = xpos;
		this.posy = ypos;
		this.rotVariation = rotationVariation;
		
	}
	
	
	public void draw() {
		
		
		rotInput += 0.05f;
		rotx = roty = rotz = parent.PI/4 + rotInput * rotVariation;
		
		parent.textureMode(NORMALIZED);
		parent.fill(128);
		parent.stroke(0, 0, 0);
		parent.strokeWeight(3);
		
		parent.pushMatrix();
			
		parent.translate(posx, posy);
		parent.rotateX(rotx);
		parent.rotateY(roty);
		parent.rotateZ(rotz);
		
		parent.scale(90);
		
		parent.beginShape(QUADS);
		parent.texture(texture1);
		
		// +Z "front" face
		parent.vertex(-1, -1,  1, 0, 0);
		parent.vertex( 1, -1,  1, 1, 0);
		parent.vertex( 1,  1,  1, 1, 1);
		parent.vertex(-1,  1,  1, 0, 1);

		// -Z "back" face
		parent.vertex( 1, -1, -1, 0, 0);
		parent.vertex(-1, -1, -1, 1, 0);
		parent.vertex(-1,  1, -1, 1, 1);
		parent.vertex( 1,  1, -1, 0, 1);

		// +Y "bottom" face
		parent.vertex(-1,  1,  1, 0, 0);
		parent.vertex( 1,  1,  1, 1, 0);
		parent.vertex( 1,  1, -1, 1, 1);
		parent.vertex(-1,  1, -1, 0, 1);

		
		// -Y "top" face
		parent.vertex(-1, -1, -1, 0, 0);
		parent.vertex( 1, -1, -1, 1, 0);
		parent.vertex( 1, -1,  1, 1, 1);
		parent.vertex(-1, -1,  1, 0, 1);

		// +X "right" face
		parent.vertex( 1, -1,  1, 0, 0);
		parent.vertex( 1, -1, -1, 1, 0);
		parent.vertex( 1,  1, -1, 1, 1);
		parent.vertex( 1,  1,  1, 0, 1);

		// -X "left" face
		parent.vertex(-1, -1, -1, 0, 0);
		parent.vertex(-1, -1,  1, 1, 0);
		parent.vertex(-1,  1,  1, 1, 1);
		parent.vertex(-1,  1, -1, 0, 1);

		parent.endShape();
		
		parent.popMatrix();
		
	}

}

