/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import gameobjects.IGameObject;
import io.ResourceManager;
import java.util.Random;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Vector2f;

public class GearPair
implements IGameObject {
    private Gear smallGear;
    private Gear bigGear;
    private Vector2f position;
    private double rotationSpeed;
    private double rotation;

    public GearPair(float gearsRotationSpeed, Vector2f position, float scale) {
        this.position = position;
        Random random = new Random();
        this.rotationSpeed = (random.nextDouble() - 0.5) / 100.0;
        int color = random.nextInt(255);
        Color filterColor = new Color(color, color, color, random.nextInt(200));
        Image smallGearImage = ResourceManager.getInstance().getImage("SMALL_GEAR").copy();
        smallGearImage.setCenterOfRotation((float)(smallGearImage.getWidth() / 2) * scale, (float)(smallGearImage.getHeight() / 2) * scale);
        Vector2f smallPos = new Vector2f(position.x, position.y);
        this.smallGear = new Gear(smallPos, gearsRotationSpeed, smallGearImage, 145.6f, filterColor);
        this.smallGear.scale = scale;
        Image bigGearImage = ResourceManager.getInstance().getImage("BIG_GEAR").copy();
        bigGearImage.setCenterOfRotation((float)(bigGearImage.getWidth() / 2) * scale, (float)(bigGearImage.getHeight() / 2) * scale);
        Vector2f bigPos = new Vector2f(position.x + (float)smallGearImage.getWidth() * scale - 30.0f * scale, position.y - (float)((bigGearImage.getHeight() - smallGearImage.getHeight()) / 2) * scale);
        this.bigGear = new Gear(bigPos, -gearsRotationSpeed, bigGearImage, 156.0f, filterColor);
        this.bigGear.rotation = 12.0;
        this.bigGear.scale = scale;
    }

    @Override
    public void render(GameContainer cont, Graphics g) throws SlickException {
        g.rotate(this.position.x, this.position.y, (float)this.rotation);
        this.smallGear.render(cont, g);
        this.bigGear.render(cont, g);
        g.resetTransform();
    }

    @Override
    public void update(GameContainer cont, int delta) throws SlickException {
        this.smallGear.update(cont, delta);
        this.bigGear.update(cont, delta);
        this.rotation += this.rotationSpeed * (double)delta;
    }

    public class Gear
    implements IGameObject {
        private Image image;
        private Color filterColor;
        private Vector2f position;
        private double rotationSpeed;
        private double rotation;
        private float scale;

        public Gear(Vector2f position, float rotationSpeed, Image image, float radius, Color filterColor) {
            this.position = position;
            this.image = image;
            this.rotationSpeed = (double)rotationSpeed / (Math.PI * 2 * (double)radius);
            this.filterColor = filterColor;
        }

        @Override
        public void render(GameContainer cont, Graphics g) {
            this.image.draw(this.position.x, this.position.y, this.scale, this.filterColor);
        }

        @Override
        public void update(GameContainer cont, int delta) {
            this.rotation += this.rotationSpeed * (double)delta;
            this.image.setRotation((float)this.rotation);
        }
    }

    public static enum GearType {
        BIG_GEAR,
        SMALL_GEAR;

    }
}

