/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import gameobjects.Direction;
import gameobjects.IDynamic;
import gameobjects.Item;
import gameobjects.Monster;
import gameobjects.Player;
import gameobjects.map.ItemTypes;
import gameobjects.map.Map;
import io.ResourceManager;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import utils.GemwarsUtils;

public class Gem
extends Item
implements IDynamic {
    private Image gemImage;
    private Animation gemDown;
    private Animation gemLeft;
    private Animation gemRight;
    private double distance;
    private Direction lastDirection;
    private Map map;

    public Gem(ItemTypes gemtype) throws SlickException {
        super(gemtype);
        if (gemtype == ItemTypes.BLUE_GEM) {
            this.gemDown = ResourceManager.fetchAnimation("GEM_BLUE_DOWN");
            this.gemRight = ResourceManager.fetchAnimation("GEM_BLUE_RIGHT");
            this.gemLeft = GemwarsUtils.reverseAnimation(this.gemRight);
        } else if (gemtype == ItemTypes.GREEN_GEM) {
            this.gemDown = ResourceManager.fetchAnimation("GEM_GREEN_DOWN");
            this.gemRight = ResourceManager.fetchAnimation("GEM_GREEN_RIGHT");
            this.gemLeft = GemwarsUtils.reverseAnimation(this.gemRight);
        } else if (gemtype == ItemTypes.RED_GEM) {
            this.gemDown = ResourceManager.fetchAnimation("GEM_RED_DOWN");
            this.gemRight = ResourceManager.fetchAnimation("GEM_RED_RIGHT");
            this.gemLeft = GemwarsUtils.reverseAnimation(this.gemRight);
        } else {
            throw new SlickException("Incorrect gem type");
        }
        this.gemImage = this.gemDown.getImage(0);
        this.speed = 0.1;
    }

    public Gem(ItemTypes gemtype, Map map) throws SlickException {
        this(gemtype);
        this.map = map;
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    public boolean isPhysicsAffected() {
        return true;
    }

    @Override
    public void render(GameContainer cont, Graphics grap) throws SlickException {
        int drawX = this.positionX * 56;
        int drawY = this.positionY * 56;
        if (this.direction == Direction.STATIONARY) {
            this.gemDown.draw((float)drawX, (float)drawY);
        }
        if (this.direction == Direction.DOWN) {
            this.gemDown.draw((float)drawX, (float)((int)((double)(drawY - 56) + this.distance)));
        }
        if (this.direction == Direction.LEFT) {
            this.gemLeft.draw((float)((int)((double)(drawX + 56) - this.distance)), (float)drawY);
        }
        if (this.direction == Direction.RIGHT) {
            this.gemRight.draw((float)((int)((double)(drawX - 56) + this.distance)), (float)drawY);
        }
    }

    public boolean isFalling() {
        return this.canDrop(this.positionX, this.positionY + 1);
    }

    public boolean isRollingRight() {
        return this.canDrop(this.positionX + 1, this.positionY + 1) && this.canDrop(this.positionX + 1, this.positionY);
    }

    public boolean isRollingLeft() {
        return this.canDrop(this.positionX - 1, this.positionY + 1) && this.canDrop(this.positionX - 1, this.positionY);
    }

    public boolean canDrop(int x, int y) {
        if (this.map.getGroundLayer().getTile((int)x, (int)y).itemType == ItemTypes.GROUND) {
            if (this.map.getObjectLayer().getTile((int)x, (int)y).itemType != ItemTypes.EMPTY) {
                return false;
            }
            for (Player p : this.map.getPlayers()) {
                if (!(p.positionX == x && p.positionY == y || p.direction == Direction.LEFT && p.positionX == x + 1 && p.positionY == y || p.direction == Direction.RIGHT && p.positionX == x - 1 && p.positionY == y) && (p.direction != Direction.UP || p.positionX != x || p.positionY != y + 1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void update(GameContainer cont, int delta) throws SlickException {
        if (this.direction != Direction.STATIONARY && this.distance <= 56.0) {
            this.distance += this.speed * (double)delta;
        } else {
            this.distance = 0.0;
            this.lastDirection = this.direction;
            this.direction = Direction.STATIONARY;
            if (this.isFalling()) {
                this.direction = Direction.DOWN;
                this.map.getObjectLayer().setTile(this.positionX, this.positionY, new Item(ItemTypes.EMPTY));
                ++this.positionY;
                this.map.getObjectLayer().setTile(this.positionX, this.positionY, this);
                for (Player p : this.map.getPlayers()) {
                    if (p.positionX != this.positionX || p.positionY != this.positionY) continue;
                    p.kill();
                }
                for (Monster m : this.map.getMonsters()) {
                    if (m.positionX != this.positionX || m.positionY != this.positionY) continue;
                    m.kill();
                }
            } else if (this.lastDirection == Direction.DOWN && this.isRollingRight()) {
                this.direction = Direction.RIGHT;
                this.map.getObjectLayer().setTile(this.positionX, this.positionY, new Item(ItemTypes.EMPTY));
                ++this.positionX;
                this.map.getObjectLayer().setTile(this.positionX, this.positionY, this);
            } else if (this.lastDirection == Direction.DOWN && this.isRollingLeft()) {
                this.direction = Direction.LEFT;
                this.map.getObjectLayer().setTile(this.positionX, this.positionY, new Item(ItemTypes.EMPTY));
                --this.positionX;
                this.map.getObjectLayer().setTile(this.positionX, this.positionY, this);
            } else {
                this.direction = Direction.STATIONARY;
            }
        }
        this.gemRight.update((long)delta);
        this.gemDown.update((long)delta);
        this.gemLeft.update((long)delta);
    }

    public int getValue() {
        return this.itemType.ordinal() * 10;
    }
}

