/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import gameobjects.AEntity;
import gameobjects.Direction;
import gameobjects.map.Map;
import io.ResourceManager;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;

public class Monster
extends AEntity {
    private Animation walkingRight;
    private Animation walkingLeft;
    private Animation walkingUp;
    private Animation walkingDown;
    private Direction direction = Direction.STATIONARY;
    private double distance;
    public int positionX;
    public int positionY;
    private Map map;
    private boolean dead = false;

    public Monster(int x, int y, Map map) {
        this.walkingRight = ResourceManager.fetchAnimation("MONSTER_RIGHT");
        this.walkingLeft = ResourceManager.fetchAnimation("MONSTER_LEFT");
        this.walkingUp = ResourceManager.fetchAnimation("MONSTER_UP");
        this.walkingDown = ResourceManager.fetchAnimation("MONSTER_DOWN");
        this.positionX = x;
        this.positionY = y;
        this.map = map;
        this.speed = 0.1;
    }

    @Override
    public void render(GameContainer cont, Graphics grap) throws SlickException {
        int drawX = this.positionX * 56;
        int drawY = this.positionY * 56;
        if (this.direction == Direction.UP) {
            this.walkingUp.draw((float)drawX, (float)((int)((double)(drawY + 56) - this.distance)));
        }
        if (this.direction == Direction.DOWN) {
            this.walkingDown.draw((float)drawX, (float)((int)((double)(drawY - 56) + this.distance)));
        }
        if (this.direction == Direction.LEFT) {
            this.walkingLeft.draw((float)((int)((double)(drawX + 56) - this.distance)), (float)drawY);
        }
        if (this.direction == Direction.RIGHT) {
            this.walkingRight.draw((float)((int)((double)(drawX - 56) + this.distance)), (float)drawY);
        }
    }

    @Override
    public void update(GameContainer cont, int delta) throws SlickException {
        if (this.direction != Direction.STATIONARY && this.distance <= 56.0) {
            this.distance += this.speed * (double)delta;
        } else {
            this.distance = 0.0;
            this.changeDirection();
        }
        if (this.direction == Direction.STATIONARY) {
            this.direction = Direction.RIGHT;
        }
    }

    private void changeDirection() throws SlickException {
        if (this.direction == Direction.RIGHT) {
            if (!this.map.isMonsterColliding(this.positionX, this.positionY - 1)) {
                --this.positionY;
                this.direction = Direction.UP;
                return;
            }
            if (!this.map.isMonsterColliding(this.positionX + 1, this.positionY)) {
                ++this.positionX;
            } else {
                this.direction = Direction.UP;
            }
        }
        if (this.direction == Direction.UP) {
            if (!this.map.isMonsterColliding(this.positionX - 1, this.positionY)) {
                --this.positionX;
                this.direction = Direction.LEFT;
                return;
            }
            if (!this.map.isMonsterColliding(this.positionX, this.positionY - 1)) {
                --this.positionY;
            } else {
                this.direction = Direction.LEFT;
            }
        }
        if (this.direction == Direction.LEFT) {
            if (!this.map.isMonsterColliding(this.positionX, this.positionY + 1)) {
                ++this.positionY;
                this.direction = Direction.DOWN;
                return;
            }
            if (!this.map.isMonsterColliding(this.positionX - 1, this.positionY)) {
                --this.positionX;
            } else {
                this.direction = Direction.DOWN;
            }
        }
        if (this.direction == Direction.DOWN) {
            if (!this.map.isMonsterColliding(this.positionX + 1, this.positionY)) {
                ++this.positionX;
                this.direction = Direction.RIGHT;
                return;
            }
            if (!this.map.isMonsterColliding(this.positionX, this.positionY + 1)) {
                ++this.positionY;
            } else {
                this.direction = Direction.RIGHT;
            }
        }
    }

    public void kill() {
        this.dead = true;
    }

    public boolean isDead() {
        return this.dead;
    }
}

