/*
 * Decompiled with CFR 0.152.
 */
package gemwars;

import gameobjects.Monster;
import gameobjects.Player;
import gameobjects.map.ItemTypes;
import gameobjects.map.Map;
import io.MapLoader;
import io.Options;
import io.ResourceManager;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.Music;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.imageout.ImageOut;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.BlobbyTransition;
import org.newdawn.slick.state.transition.EmptyTransition;
import org.newdawn.slick.state.transition.Transition;
import org.newdawn.slick.util.Log;

public class GameplayState
extends BasicGameState {
    int stateID = -1;
    Music gamemusic = null;
    private List<File> availableMaps;
    private int currentMapIndex = 0;
    boolean isMapChanged = false;
    private Map map;

    public GameplayState(int stateID) {
        this.stateID = stateID;
    }

    public void init(GameContainer cont, StateBasedGame state) throws SlickException {
        File file = new File("src/resources/maps/");
        if (!file.exists()) {
            file = new File("resources/maps/");
        }
        this.availableMaps = MapLoader.findAvailableMaps(file);
        try {
            this.map = MapLoader.loadMap(this.availableMaps.get(this.currentMapIndex));
        }
        catch (IOException e) {
            throw new SlickException("Can't load map file. ", (Throwable)e);
        }
        this.gamemusic = ResourceManager.getInstance().getMusic("GAME_MUSIC");
    }

    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        super.enter(container, game);
        this.gamemusic.setVolume(0.0f);
        this.gamemusic.fade(1000, Options.getInstance().getMusicVolume(), false);
        this.gamemusic.loop(1.0f, Options.getInstance().getMusicVolume());
        this.map.enter(container);
    }

    public void leave(GameContainer container, StateBasedGame game) throws SlickException {
        super.leave(container, game);
        this.gamemusic.fade(500, 0.0f, true);
    }

    public void render(GameContainer cont, StateBasedGame state, Graphics graph) throws SlickException {
        this.map.render(cont, graph);
        graph.drawString("SCORE: " + this.map.getPlayer(0).getScore(), 500.0f, 0.0f);
        graph.drawString(" GEMS: " + this.map.getPlayer(0).getGems() + "/" + this.map.getGemCount(), 500.0f, 15.0f);
        graph.drawString("LIVES: " + this.map.getPlayer(0).getLives(), 500.0f, 30.0f);
    }

    public void update(GameContainer cont, StateBasedGame state, int delta) throws SlickException {
        this.map.update(cont, delta);
        Input input = cont.getInput();
        if (input.isKeyPressed(11)) {
            for (Monster m : this.map.getMonsters()) {
                m.kill();
            }
        }
        for (Monster m : this.map.getMonsters()) {
            if (!m.isDead()) continue;
            this.map.drawDiamondMatrix(m.positionX, m.positionY);
        }
        for (Player p : this.map.getPlayers()) {
            if (this.map.hasPlayerDied(p)) {
                p.kill();
            }
            if (p.isDead()) {
                this.map.drawDiamondMatrix(p.positionX, p.positionY);
                if (this.map.getPlayer((int)0).lives <= 0) {
                    state.enterState(3, (Transition)new EmptyTransition(), (Transition)new BlobbyTransition());
                } else {
                    try {
                        Map tempMap;
                        this.map = tempMap = MapLoader.loadMap(this.availableMaps.get(this.currentMapIndex), this.map.getPlayers());
                        tempMap.enter(cont);
                    }
                    catch (IOException e) {
                        throw new SlickException(e.getMessage());
                    }
                }
            }
            if (!this.map.isGoalOpen()) continue;
            List<Point> goals = this.map.findItemPositions(this.map.getSpecialLayer(), ItemTypes.GOAL);
            Point point = goals.get(0);
            if (p.positionX != point.x || p.positionY != point.y) continue;
            ++this.currentMapIndex;
            this.isMapChanged = true;
        }
        if (input.isKeyDown(29) || input.isKeyDown(157)) {
            if (input.isKeyPressed(203)) {
                --this.currentMapIndex;
                this.isMapChanged = true;
            }
            if (input.isKeyPressed(205)) {
                ++this.currentMapIndex;
                this.isMapChanged = true;
            }
            if (this.currentMapIndex < 0) {
                this.currentMapIndex = this.availableMaps.size() - 1;
            } else if (this.currentMapIndex >= this.availableMaps.size()) {
                this.currentMapIndex = 0;
            }
        }
        if (this.isMapChanged) {
            try {
                this.map = MapLoader.loadMap(this.availableMaps.get(this.currentMapIndex));
                this.map.enter(cont);
                this.isMapChanged = false;
            }
            catch (IOException e) {
                Log.error((Throwable)e);
            }
        }
        if (input.isKeyPressed(68)) {
            Image target = new Image(cont.getWidth(), cont.getHeight());
            cont.getGraphics().copyArea(target, 0, 0);
            ImageOut.write((Image)target, (String)"screenshot.png", (boolean)false);
            target.destroy();
        }
        if (input.isKeyPressed(1)) {
            state.enterState(0, (Transition)new EmptyTransition(), (Transition)new BlobbyTransition());
        }
    }

    public int getID() {
        return this.stateID;
    }
}

