/*
 * Decompiled with CFR 0.152.
 */
package gemwars;

import gemwars.ConfigurationMenuState;
import gemwars.GameOverState;
import gemwars.GameplayState;
import gemwars.MainMenuState;
import gemwars.event.GemwarsEvent;
import gemwars.event.GemwarsEventType;
import gemwars.event.GemwarsListener;
import io.Options;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.Game;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.GameState;
import org.newdawn.slick.state.StateBasedGame;

public class Gemwars
extends StateBasedGame {
    public static final int MAINMENUSTATE = 0;
    public static final int GAMEPLAYSTATE = 1;
    public static final int CONFIGURATION_MENU_STATE = 2;
    public static final int GAMEOVERSTATE = 3;
    private static List<GemwarsListener> gemwarsListeners = new ArrayList<GemwarsListener>();

    public Gemwars() {
        super("GemWars");
    }

    public static void main(String[] args) throws SlickException {
        Options properties = Gemwars.loadConfigurations();
        AppGameContainer app = new AppGameContainer((Game)new Gemwars());
        app.setDisplayMode(properties.getScreenWitdh().intValue(), properties.getScreenHeight().intValue(), properties.getFullscreen().booleanValue());
        app.setTargetFrameRate(properties.getTargetFrameRate().intValue());
        app.setMusicVolume(properties.getMusicVolume());
        app.setSoundVolume(properties.getSoundVolume());
        app.start();
    }

    private static Options loadConfigurations() throws SlickException {
        Options properties = Options.getInstance();
        try {
            properties.load(new File("Gemwars.properties"));
        }
        catch (NumberFormatException e) {
            throw new SlickException("Can't parse number from the string.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new SlickException("General error", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SlickException("General error", (Throwable)e);
        }
        catch (IOException e) {
            throw new SlickException("Can't read confguration file. ", (Throwable)e);
        }
        return properties;
    }

    public void initStatesList(GameContainer gameContainer) throws SlickException {
        this.addState((GameState)new MainMenuState(0));
        this.addState((GameState)new GameplayState(1));
        this.addState((GameState)new ConfigurationMenuState(2));
        this.addState((GameState)new GameOverState(3));
        this.enterState(0);
    }

    public static void addGemwarsListener(GemwarsListener listener) {
        gemwarsListeners.add(listener);
    }

    public static void fireGemwarsEvent(GemwarsEventType event) {
        for (GemwarsListener listener : gemwarsListeners) {
            listener.gemwarsEventPerformed(new GemwarsEvent(event));
        }
    }

    public void removeGemwarsListener(GemwarsListener listener) {
        gemwarsListeners.remove(listener);
    }
}

