/*
 * Decompiled with CFR 0.152.
 */
package gemwars;

import gameobjects.Item;
import gameobjects.map.ItemTypes;
import io.Options;
import io.ResourceManager;
import java.awt.Desktop;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.Music;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.BlobbyTransition;
import org.newdawn.slick.state.transition.EmptyTransition;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;
import org.newdawn.slick.state.transition.Transition;
import org.newdawn.slick.util.Log;

public class MainMenuState
extends BasicGameState {
    int stateID = -1;
    Image background = null;
    Image newGameOption = null;
    Image multiplayerOption = null;
    Image optionsOption = null;
    Image exitOption = null;
    Sound menusound = null;
    Music menumusic = null;
    Music gamemusic = null;
    HashMap<String, Animation> menuanimations = new HashMap();
    UnicodeFont fontti = null;
    private static int menuX = 38;
    private static int menuY = 240;
    private static int menuAnimX = 43;
    private static int menuAnimY = 40;
    float alpha = 0.0f;
    int currentSelection = 1;
    int selected = 0;
    private Item item;

    public MainMenuState(int stateID) {
        this.stateID = stateID;
    }

    public void init(GameContainer gc, StateBasedGame game) throws SlickException {
        try {
            File file = new File("src/resources/resources.xml");
            if (!file.exists()) {
                file = new File("resources/resources.xml");
            }
            FileInputStream fileStream = new FileInputStream(file);
            ResourceManager.getInstance().loadResources(fileStream, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.background = ResourceManager.getInstance().getImage("MENU_BG");
        Image menuOptions = ResourceManager.getInstance().getImage("MENU_OPTIONS");
        this.newGameOption = menuOptions.getSubImage(0, 0, 151, 201);
        this.multiplayerOption = menuOptions.getSubImage(152, 0, 151, 201);
        this.optionsOption = menuOptions.getSubImage(304, 0, 151, 201);
        this.exitOption = menuOptions.getSubImage(456, 0, 151, 201);
        this.menusound = ResourceManager.getInstance().getSound("MENU_SOUND");
        this.menumusic = ResourceManager.getInstance().getMusic("MENU_MUSIC");
        this.menuanimations.put("single", ResourceManager.getInstance().getAnimation("MENUANI_SP"));
        this.menuanimations.put("multi", ResourceManager.getInstance().getAnimation("MENUANI_MP"));
        this.menuanimations.put("options", ResourceManager.getInstance().getAnimation("MENUANI_OPTIONS"));
        this.menuanimations.put("exit", ResourceManager.getInstance().getAnimation("MENUANI_EXIT"));
        Font font = new Font("Arial", 1, 20);
        this.fontti = new UnicodeFont(font);
        this.item = new Item(ItemTypes.DARK_BOULDER);
        this.item.positionX = 200;
        this.item.positionY = 30;
    }

    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        super.enter(container, game);
        this.menumusic.setVolume(0.0f);
        this.menumusic.fade(1000, Options.getInstance().getMusicVolume(), false);
        this.menumusic.loop(1.0f, Options.getInstance().getMusicVolume());
    }

    public void leave(GameContainer container, StateBasedGame game) throws SlickException {
        super.leave(container, game);
        this.menumusic.fade(500, 0.0f, true);
    }

    public void render(GameContainer gc, StateBasedGame game, Graphics g) throws SlickException {
        this.background.draw(0.0f, 0.0f);
        switch (this.currentSelection) {
            case 2: {
                this.menuanimations.get("multi").draw((float)menuAnimX, (float)menuAnimY);
                this.multiplayerOption.draw((float)menuX, (float)menuY);
                break;
            }
            case 3: {
                this.menuanimations.get("options").draw((float)menuAnimX, (float)menuAnimY);
                this.optionsOption.draw((float)menuX, (float)menuY);
                break;
            }
            case 4: {
                this.menuanimations.get("exit").draw((float)menuAnimX, (float)menuAnimY);
                this.exitOption.draw((float)menuX, (float)menuY);
                break;
            }
            default: {
                this.currentSelection = 1;
                this.menuanimations.get("single").draw((float)menuAnimX, (float)menuAnimY);
                this.newGameOption.draw((float)menuX, (float)menuY);
            }
        }
        this.item.render(gc, g);
    }

    public void update(GameContainer gc, StateBasedGame game, int delta) throws SlickException {
        Input input = gc.getInput();
        if (input.isKeyPressed(28)) {
            switch (this.selected) {
                case 1: {
                    game.enterState(1, (Transition)new EmptyTransition(), (Transition)new BlobbyTransition());
                    break;
                }
                case 2: {
                    Desktop desktop;
                    if (!Desktop.isDesktopSupported() || !(desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) break;
                    URI uri = null;
                    try {
                        uri = new URI(Options.getInstance().getGemwarsFormUrl());
                        desktop.browse(uri);
                    }
                    catch (IOException ioe) {
                        Log.error((String)("Can't open open gemwars url, oh pleas borwser manually to url: " + uri.toString()));
                    }
                    catch (URISyntaxException use) {
                        Log.error((String)("Can't open open gemwars url, oh pleas borwser manually to url: " + uri.toString()));
                    }
                    break;
                }
                case 3: {
                    game.enterState(2, (Transition)new FadeOutTransition(), (Transition)new FadeInTransition());
                    break;
                }
                case 4: {
                    gc.exit();
                    break;
                }
            }
        }
        if (input.isKeyPressed(1)) {
            gc.exit();
        }
    }

    public void keyPressed(int key, char c) {
        if (key == 200) {
            --this.currentSelection;
            if (this.currentSelection < 1) {
                this.currentSelection = 4;
            }
            this.menusound.play(1.0f, Options.getInstance().getSoundVolume());
        }
        if (key == 208) {
            ++this.currentSelection;
            if (this.currentSelection > 4) {
                this.currentSelection = 1;
            }
            this.menusound.play(1.0f, Options.getInstance().getSoundVolume());
        }
        if (key == 28) {
            this.selected = this.currentSelection;
            this.menusound.play(1.0f, Options.getInstance().getSoundVolume());
        }
    }

    public int getID() {
        return this.stateID;
    }
}

