/*
 * Decompiled with CFR 0.152.
 */
package io;

import gameobjects.Boulder;
import gameobjects.Gem;
import gameobjects.Item;
import gameobjects.Monster;
import gameobjects.Player;
import gameobjects.map.ItemTypes;
import gameobjects.map.Layer;
import gameobjects.map.LayerTypes;
import gameobjects.map.Map;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.util.Log;
import org.newdawn.slick.util.ResourceLoader;

public class MapLoader {
    public static Map loadMap(File file) throws IOException, SlickException {
        return MapLoader.loadMap(file, null);
    }

    public static Map loadMap(File file, List<Player> players) throws IOException, SlickException {
        Log.info((String)("Loading level from a file : " + file.getName()));
        Map map = null;
        if (!file.isFile()) {
            throw new IOException("Given file is not file.");
        }
        Scanner f = null;
        try {
            try {
                InputStream in = ResourceLoader.getResourceAsStream((String)file.toString());
                f = new Scanner(in);
                while (f.hasNextLine()) {
                    map = new Map();
                    map.setFilename(file.getName());
                    map.setName(f.nextLine());
                    map.setCreator(f.nextLine());
                    int gems = 0;
                    try {
                        gems = Integer.parseInt(f.nextLine());
                    }
                    catch (NumberFormatException e) {
                        gems = 0;
                    }
                    map.setGemCount(gems);
                    int time = 60;
                    try {
                        time = Integer.parseInt(f.nextLine());
                    }
                    catch (NumberFormatException e) {
                        time = 60;
                    }
                    map.setTime(time);
                    int i = 0;
                    while (i < 4) {
                        String layerName = f.nextLine();
                        int layerWidth = 0;
                        try {
                            layerWidth = Integer.parseInt(f.nextLine());
                        }
                        catch (NumberFormatException e) {
                            layerWidth = 60;
                        }
                        int layerHeight = 0;
                        try {
                            layerHeight = Integer.parseInt(f.nextLine());
                        }
                        catch (NumberFormatException e) {
                            layerHeight = 60;
                        }
                        String tileFilename = f.nextLine();
                        if (LayerTypes.valueOf(layerName) == LayerTypes.LAYER_COLLISION) {
                            map.createCollision(layerWidth, layerHeight);
                            int y = 0;
                            while (y < layerHeight) {
                                StringBuffer line = new StringBuffer(f.nextLine());
                                int start = 0;
                                int end = 0;
                                int x = 0;
                                while (x < layerWidth) {
                                    end = line.indexOf(" ", start);
                                    if (end == -1) {
                                        end = line.length();
                                    }
                                    int collision = 0;
                                    try {
                                        collision = Integer.parseInt(line.substring(start, end));
                                    }
                                    catch (NumberFormatException e) {
                                        collision = 0;
                                    }
                                    if (collision == 1) {
                                        map.setCollision(x, y, true);
                                    }
                                    start = end + 1;
                                    ++x;
                                }
                                ++y;
                            }
                        } else {
                            Layer l = new Layer(layerWidth, layerHeight, LayerTypes.valueOf(layerName));
                            if (map.setLayer(l)) {
                                int y = 0;
                                while (y < layerHeight) {
                                    StringBuffer line = new StringBuffer(f.nextLine());
                                    int start = 0;
                                    int end = 0;
                                    int x = 0;
                                    while (x < layerWidth) {
                                        end = line.indexOf(" ", start);
                                        if (end == -1) {
                                            end = line.length();
                                        }
                                        int item = 0;
                                        try {
                                            item = Integer.parseInt(line.substring(start, end));
                                        }
                                        catch (NumberFormatException e) {
                                            item = 0;
                                        }
                                        Item tile = null;
                                        if (item == ItemTypes.BLUE_GEM.ordinal() || item == ItemTypes.GREEN_GEM.ordinal() || item == ItemTypes.RED_GEM.ordinal()) {
                                            tile = new Gem(ItemTypes.getType(item), map);
                                        } else if (item == ItemTypes.DARK_BOULDER.ordinal() || item == ItemTypes.WHITE_BOULDER.ordinal()) {
                                            tile = new Boulder(ItemTypes.getType(item), map);
                                        } else if (item == ItemTypes.MONSTER.ordinal()) {
                                            map.add(new Monster(x, y, map));
                                        } else {
                                            tile = new Item(ItemTypes.getType(item));
                                        }
                                        if (tile != null) {
                                            tile.positionX = x;
                                            tile.positionY = y;
                                            l.setTile(x, y, tile);
                                        }
                                        start = end + 1;
                                        ++x;
                                    }
                                    ++y;
                                }
                            }
                        }
                        ++i;
                    }
                }
                map.initPlayers(players);
            }
            catch (NoSuchElementException e) {
                throw new SlickException("Error loading map file", (Throwable)e);
            }
            catch (RuntimeException e) {
                throw new SlickException("Error loading map file", (Throwable)e);
            }
        }
        finally {
            if (f != null) {
                f.close();
            }
        }
        return map;
    }

    public static List<File> findAvailableMaps(File path) {
        ArrayList<File> maps = new ArrayList<File>();
        MapLoader.searchRecursivelyForMapFiles(maps, path);
        Collections.sort(maps);
        return maps;
    }

    private static void searchRecursivelyForMapFiles(List<File> maps, File path) {
        File[] fileArray = path.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName;
            File file = fileArray[n2];
            if (file.isDirectory()) {
                MapLoader.searchRecursivelyForMapFiles(maps, file);
            }
            if (file.isFile() && (fileName = file.getName()).endsWith(".gem")) {
                maps.add(file);
            }
            ++n2;
        }
    }
}

