/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.Property;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Properties;
import org.newdawn.slick.util.Log;

public class Options {
    private static Options __instance = null;
    @Property(value="soundvolume")
    private Float soundVolume = Float.valueOf(1.0f);
    @Property(value="musicvolume")
    private Float musicVolume = Float.valueOf(0.8f);
    @Property(value="isfullscreeninuse")
    private Boolean fullscreen = false;
    @Property(value="screenwidth")
    private Integer screenWitdh = 640;
    @Property(value="screenheight")
    private Integer screenHeight = 480;
    @Property(value="targetFrameRate")
    private Integer targetFrameRate = 60;
    @Property(value="gemwarsFormUrl")
    private String gemwarsFormUrl = "http://teemuki.eu/gemwars/";
    public static final String CONFIGURATION_FILE = "Gemwars.properties";

    private Options() {
    }

    public static Options getInstance() {
        if (__instance == null) {
            __instance = new Options();
        }
        return __instance;
    }

    public void save(File file) throws IllegalArgumentException, IllegalAccessException, IOException {
        Properties properties = new Properties();
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Property annotation = field.getAnnotation(Property.class);
            if (annotation != null) {
                this.readKey(field, annotation);
                properties.put(annotation.value(), field.get(this).toString());
            }
            ++n2;
        }
        FileOutputStream stream = new FileOutputStream(file);
        properties.store(stream, "Gemwars properties file is a Gem");
        Log.info((String)("Configurations saved to a file : " + file.getAbsolutePath()));
    }

    private String readKey(Field field, Property annotation) {
        String key = annotation.value();
        if (key.length() == 0) {
            key = field.getName();
        }
        return key.trim();
    }

    /*
     * Unable to fully structure code
     */
    public void load(File file) throws RuntimeException, IllegalArgumentException, IllegalAccessException, IOException {
        if (file.isFile()) {
            stream = new FileInputStream(file);
            properties = new Properties();
            properties.load(stream);
            var7_4 = this.getClass().getDeclaredFields();
            var6_5 = var7_4.length;
            var5_6 = 0;
            while (var5_6 < var6_5) {
                field = var7_4[var5_6];
                annotation = field.getAnnotation(Property.class);
                if (annotation != null) {
                    key = this.readKey(field, annotation);
                    value = properties.getProperty(key);
                    if (value != null) {
                        try {
                            field.setAccessible(true);
                            if (field.getType().equals(Double.class)) {
                                field.set(this, Double.parseDouble(value));
                            }
                            if (field.getType().equals(Float.class)) {
                                field.set(this, Float.valueOf(Float.parseFloat(value)));
                            }
                            if (field.getType().equals(String.class)) {
                                field.set(this, value);
                            }
                            if (field.getType().equals(Integer.class)) {
                                field.set(this, Integer.parseInt(value));
                            }
                            if (field.getType().equals(Short.class)) {
                                field.set(this, Short.parseShort(value));
                            }
                            if (field.getType().equals(Long.class)) {
                                field.set(this, Long.parseLong(value));
                            }
                            if (!field.getType().equals(Byte.class)) ** GOTO lbl37
                            field.set(this, Byte.parseByte(value));
                        }
                        catch (NumberFormatException e) {
                            message = "Can't convert field [ " + field.getName() + " ] value " + value;
                            throw new RuntimeException(message, e);
                        }
                    } else {
                        message = "Usign default value [ " + field.getName() + " ] value " + field.get(this);
                        Log.info((String)message);
                    }
                }
lbl37:
                // 5 sources

                ++var5_6;
            }
        }
        Log.info((String)("Configuration are now loaded from file :" + file.getAbsolutePath()));
    }

    public void setSoundVolume(float soundVolume) {
        this.soundVolume = Float.valueOf(soundVolume);
    }

    public float getSoundVolume() {
        return this.soundVolume.floatValue();
    }

    public void setMusicVolume(float musicVolume) {
        this.musicVolume = Float.valueOf(musicVolume);
    }

    public float getMusicVolume() {
        return this.musicVolume.floatValue();
    }

    public Boolean getFullscreen() {
        return this.fullscreen;
    }

    public void setFullscreen(Boolean fullscreen) {
        this.fullscreen = fullscreen;
    }

    public Integer getScreenWitdh() {
        return this.screenWitdh;
    }

    public void setScreenWitdh(Integer screenWitdh) {
        this.screenWitdh = screenWitdh;
    }

    public Integer getScreenHeight() {
        return this.screenHeight;
    }

    public void setScreenHeight(Integer screenHeight) {
        this.screenHeight = screenHeight;
    }

    public void setSoundVolume(Float soundVolume) {
        this.soundVolume = soundVolume;
    }

    public Integer getTargetFrameRate() {
        return this.targetFrameRate;
    }

    public void setTargetFrameRate(Integer targetFrameRate) {
        this.targetFrameRate = targetFrameRate;
    }

    public String getGemwarsFormUrl() {
        return this.gemwarsFormUrl;
    }

    public void setGemwarsFormUrl(String gemwarsFormUrl) {
        this.gemwarsFormUrl = gemwarsFormUrl;
    }
}

