#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrixInverse;
uniform mat3 NormalMatrix;
uniform vec3 camera_pos;
uniform samplerBuffer hexagon_data;
uniform float time;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec3 normal;
out vec2 uv;
out vec2 pos_zw;
out float intensity;

#include <hexagons/transformations_include.vert>


void main()
{
	vec4 hexPos = texelFetch(hexagon_data, gl_InstanceID*2 + 0); // pos.xyz, scale
	vec4 hexParams = texelFetch(hexagon_data, gl_InstanceID*2 + 1); // axis, angle

	vec3 pos = POSITION;
	vec3 n = NORMAL;

	float len = length( hexPos.xz * (1.0/3.0) );
	float osc = 0.5 + 0.5*sin( (time + len) );
	float angle = hexParams.w;

	mat3 mr;
	rotate_around_axis(hexParams.xyz, angle, mr);
	pos.xz *= hexPos.w;
	pos *= osc;

	pos = mr*pos;
	n = mr*n;

	pos += hexPos.xyz;
	pos.y += osc*0.5;

	uv = TEXCOORD;
	normal = NormalMatrix * n;
	intensity = 1.0;

	vec4 proj_pos = ModelViewProjectionMatrix * vec4(pos, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
