
void rotateAroundZ(inout vec3 p, inout vec3 n, in float angle)
{
	float s = sin(angle);
	float c = cos(angle);
	
	float x = p.x;
	p.x = x*c + p.y*s;
	p.y = x*(-s) + p.y*c;

	x = n.x;
	n.x = x*c + n.y*s;
	n.y = x*-s + n.y*c;
}

void rotateAroundX(inout vec3 p, inout vec3 n, in float angle)
{
	float s = sin(angle);
	float c = cos(angle);
	
	float y = p.y;
	p.y = y*c + p.z*s;
	p.z = y*(-s) + p.z*c;

	y = n.y;
	n.y = y*c + n.z*s;
	n.z = y*-s + n.z*c;
}

void rotate_around_axis(in vec3 axis, in float angle, out mat3 mr)
{
	float c = cos(angle);
	float s = sin(angle);
	float one_minus_c = 1.0 - c;

	mr[0].x = c + one_minus_c*axis.x*axis.x;
	mr[0].y = axis.x*axis.y*one_minus_c - axis.z*s;
	mr[0].z = axis.x*axis.z*one_minus_c + axis.y*s;

	mr[1].x = axis.x*axis.y*one_minus_c + axis.z*s;
	mr[1].y = c + one_minus_c*axis.y*axis.y;
	mr[1].z = axis.y*axis.z*one_minus_c - axis.x*s;

	mr[2].x = axis.x*axis.z*one_minus_c - axis.y*s;
	mr[2].y = axis.y*axis.z*one_minus_c + axis.x*s;
	mr[2].z = c + one_minus_c*axis.z*axis.z;
}
