#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat4 WorldMatrix;
uniform mat3 NormalMatrix;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec2 pos_zw;
out vec3 normal;
out vec3 ec_pos;
out vec2 uv;

void main()
{
	vec3 wpos = vec3(WorldMatrix * vec4(POSITION, 1.0));
	uv = wpos.xy*vec2(1.0/2.5, 1.0/2.5) - vec2(0.5);

	normal = NormalMatrix * NORMAL;
	ec_pos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));

	vec4 proj_pos = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
