
uniform vec4 pincushion_texel_size; // width, height, 1/width, 1/height

vec4 bilinear_sampling(sampler2D sampler, vec2 uv)
{
    vec2 f = fract( uv*pincushion_texel_size.xy );
	uv += pincushion_texel_size.zw*0.5;
    //uv = floor(uv);
    vec4 t00 = texture(sampler, uv);
    vec4 t10 = texture(sampler, uv+vec2(pincushion_texel_size.z, 0.0));
    vec4 tA = mix(t00, t10, f.x);
    vec4 t01 = texture(sampler, uv+vec2(0.0, pincushion_texel_size.w));
    vec4 t11 = texture(sampler, uv+vec2(pincushion_texel_size.zw));
    vec4 tB = mix(t01, t11, f.x);
    return mix(tA, tB, f.y);
}


void getPincushionOffsetUV(out vec2 offset, out vec2 uv)
{
	float y_off = floor( float(gl_InstanceID) / pincushion_texel_size.x );
	float x_off = float(gl_InstanceID) - y_off*pincushion_texel_size.x;
	offset = vec2(x_off, y_off) - vec2(pincushion_texel_size.xy/2.0);
	uv = vec2(x_off, y_off) * pincushion_texel_size.zw;
}
