#version 330 core

uniform sampler2D normal_depth;

uniform vec2 TexelSize;
uniform vec3 CameraRange; // 2*near, (far + near), (far - near)

in vec2 uv;

layout (location = 0) out vec4 frag_color;

float sampleNormal(in sampler2D smp, in vec2 uv, in vec3 currentNormal)
{
	vec3 n = texture(smp, uv).xyz;
	return dot(currentNormal, n);
}


void main()
{
	const float AngleThreshold = 0.95;

	vec3 currentNormal = texture(normal_depth, uv).xyz;

	float dot00 = sampleNormal(normal_depth, uv + vec2(-TexelSize.x,  TexelSize.y), currentNormal);
	float dot01 = sampleNormal(normal_depth, uv + vec2(  0.0,  TexelSize.y), currentNormal);
	float dot02 = sampleNormal(normal_depth, uv + vec2( TexelSize.x,  TexelSize.y), currentNormal);
	float dot10 = sampleNormal(normal_depth, uv + vec2(-TexelSize.x,   0.0), currentNormal);
	float dot12 = sampleNormal(normal_depth, uv + vec2( TexelSize.x,   0.0), currentNormal);
	float dot20 = sampleNormal(normal_depth, uv + vec2(-TexelSize.x, -TexelSize.y), currentNormal);
	float dot21 = sampleNormal(normal_depth, uv + vec2(  0.0, -TexelSize.y), currentNormal);
	float dot22 = sampleNormal(normal_depth, uv + vec2( TexelSize.x, -TexelSize.y), currentNormal);
	
	float cosAngle = min(dot00, dot01);
	cosAngle = min(cosAngle, dot02);
	cosAngle = min(cosAngle, dot10);
	cosAngle = min(cosAngle, dot12);
	cosAngle = min(cosAngle, dot20);
	cosAngle = min(cosAngle, dot21);
	cosAngle = min(cosAngle, dot22);

	frag_color = vec4( cosAngle > AngleThreshold ? 0.0 : 1.0 );
}
