#version 330 core

in vec3 gs_oldPosition[6];
in vec3 gs_forces[6];
in vec3 gs_params[6]; // radius, ?, active

layout(triangles_adjacency) in;
layout(points, max_vertices = 1) out;

out vec3 position;
out vec3 oldPosition;
out vec3 forces;
out vec3 params; // radius, ?, active


void main()
{
	// we love hardcoded stuff
	float restLength[6] = float[6](
		0.0,  // origin
		1.0,  // +y
		1.0,  // +x
		1.0,  // +z
		1.41, // +x,+y
		1.73  // +x,+y,+z
	);

	vec3 pos = gl_in[0].gl_Position.xyz;
	if ( gs_params[0].y < 1.0 && gs_params[0].z > 0.0 )
	{
		for (int i=1; i < 6; i++)
		{
			vec3 diff = gl_in[i].gl_Position.xyz - pos;
			float len = length(diff);
			diff *= ((len - restLength[i]) / len) * 0.5;
			pos += diff*gs_params[i].z;
		}
	}

	// apply additional constraints here

	position = pos;
	oldPosition = gs_oldPosition[0];
	forces = gs_forces[0];
	params = gs_params[0];

	EmitVertex();
	EndPrimitive();
}
