#version 330 core

uniform float time;
uniform float timeSqr;

in vec3 gs_oldPosition[1];
in vec3 gs_forces[1];
in vec3 gs_params[1]; // radius, fixed, active

out vec3 position;
out vec3 oldPosition;
out vec3 forces;
out vec3 params; // radius, ?, active

layout(points) in;
layout(points, max_vertices = 1) out;

void main()
{
	vec3 pos = gl_in[0].gl_Position.xyz;
	vec3 oldPos = gs_oldPosition[0];
	vec3 f = gs_forces[0];
	vec3 p = gs_params[0];

	if ( gs_params[0].y < 1.0 && gs_params[0].z > 0.0 )
	{
		// update forces here

		// away from center
#if 0
		float dist = length(pos);
		vec3 dir = normalize(pos);
		float strength = (1.0 / 10.0) / dist;
		f += dir * strength;
#else
		//float dist = length(pos);
		//float strength = (1.0 / 10.0) / dist;
		float strength = 0.001 * time;
		float s = sin(strength);
		float c = cos(strength);
		f = oldPos;
		f.x = pos.x*c - pos.z*s;
		f.z = pos.x*s + pos.z*c;
		pos = f;
#endif

		// apply forces
#if 0
		vec3 tmp = pos;
		pos += (pos - oldPos) + f*timeSqr;
		oldPos = tmp;
#endif
	}

	position = pos;
	oldPosition = oldPos;
	forces = gs_forces[0];
	params = p;
	EmitVertex();
	EndPrimitive();
}
