#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;
uniform mat4 WorldMatrix;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec2 uv;
out vec3 light_pos;
out vec3 normal;
out vec3 opos;

void main()
{
	uv = TEXCOORD;
	light_pos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	normal = NormalMatrix * NORMAL;
	opos = vec3(WorldMatrix * vec4(POSITION, 1.0));
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
