#version 330 core

uniform mat4 ModelViewMatrix;
uniform samplerBuffer hexagon_data;
uniform float time;

in vec3 POSITION;

out vec3 gs_light_params; // radius
out vec3 gs_light_color;

void main()
{
	vec4 hexPos = texelFetch(hexagon_data, gl_InstanceID*2); // pos.xyz, scale
	float len = length( hexPos.xz * (1.0/3.0) );
	float osc = 0.5 + 0.5*sin( (time + len) );
	hexPos.y += 0.5 + osc*0.5;
	hexPos.w = 1.0;

	gs_light_params = vec3(osc*3.0);
	gs_light_color = vec3(osc);

	gl_Position = ModelViewMatrix * hexPos;
}
