#version 330 core

uniform sampler2D font;
uniform vec4 color;
uniform vec4 glow_color;
uniform vec4 outline_color;

in vec2 uv;
in vec3 normal;
in vec2 pos_zw;

layout (location = 0) out vec4 diffuse_specular;
layout (location = 1) out vec4 normal_depth;

void main()
{
	const vec2 glow_offset = vec2(-0.004, -0.004);	

	vec4 base_color = color;
	base_color.a = texture(font, uv).x;
#if 0
	float alpha_dist = base_color.a;
	float width = fwidth(uv.x)*25.0;
	vec2 outline_limits = vec2(0.4+width*2.0, 0.5+width*2.0);
	if ( alpha_dist >= outline_limits.x && alpha_dist <= outline_limits.y )
	{
		float outline_alpha;
		if ( alpha_dist < outline_limits.y )
			outline_alpha = smoothstep(outline_limits.x, outline_limits.y, alpha_dist);
		else
			outline_alpha = smoothstep(outline_limits.y, outline_limits.x, alpha_dist);
		base_color = mix(base_color, outline_color, outline_alpha);
	}

	float glow_dist = texture(font, uv+glow_offset).x;
	base_color.xyz = mix(glow_color.xyz, base_color.xyz, base_color.a);

	base_color.xyz *= base_color.a;
#endif

	if ( base_color.a < 0.5 ) discard; // alpha discard

	diffuse_specular.rgb = base_color.rgb;
	diffuse_specular.a = 1.0;

	normal_depth.xyz = normalize(normal);
	normal_depth.w = pos_zw.x/pos_zw.y;
}
