#version 330 core

uniform sampler2D font;
uniform sampler2D normal_depth;
uniform vec2 viewport;
uniform vec4 color;
uniform vec4 glow_color;
uniform vec4 outline_color;

in vec2 uv;
in vec3 light_pos;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_include.frag>

void main()
{
	vec4 base_color = color * texture(font, uv).x;
	if ( base_color.a < 0.5 ) discard;

	vec2 uv_pos = gl_FragCoord.xy * viewport;
	vec4 nd = texture(normal_depth, uv_pos);

	vec3 pos = calc_position(uv_pos, nd.w);
	if ( (pos.z-0.1) > light_pos.z ) discard;

	frag_color.rgb = base_color.rgb;
	frag_color.a = 0.0;
}
