#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec2 uv;
out vec3 light_pos;

void main()
{
	uv = TEXCOORD;
	light_pos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
