
BlendState AdditiveBlend {
	BlendEnable[0] = True;
	BlendOpAlpha = ADD;
    BlendOp = ADD;
    DestBlendAlpha = ZERO;
    DestBlend = ONE;
    AlphaToCoverageEnable = False;
    SrcBlendAlpha = ZERO;
    SrcBlend = ONE;
};

/*
BlendState SubtractiveBlend {
	BlendEnable[0] = True;
	BlendOpAlpha = SUB;
    BlendOp = SUB;
    DestBlendAlpha = ZERO;
    DestBlend = ONE;
    AlphaToCoverageEnable = False;
    SrcBlendAlpha = ZERO;
    SrcBlend = ONE;
};
*/

BlendState SolidBlend {
	BlendEnable[0] = False;
};

DepthStencilState DepthOn
{
	DepthEnable = TRUE;
	DepthWriteMask = ALL;
};
DepthStencilState DepthOff
{
	DepthEnable = FALSE;
	DepthWriteMask = ZERO;
};

DepthStencilState DepthWriteOff
{
	DepthEnable = TRUE;
	DepthWriteMask = ZERO;
};

RasterizerState rasterizerState {
	FillMode = Solid;
	CullMode = None;
	FrontCounterClockwise =	FALSE;
	DepthBias = 0;
	SlopeScaledDepthBias = 0.0f;
	DepthBiasClamp = 0.0f;
	DepthClipEnable = TRUE;
	ScissorEnable =	FALSE;
	MultisampleEnable = FALSE;
	AntialiasedLineEnable = FALSE;
};

cbuffer ConstantBuffer : register( b0 )
{
	Matrix ModelViewProjectionMatrix;
	float4 billUp;
	float4 billRight;
	float4 timeAmpRtwRth;
}

Texture2D tex;

SamplerState TexSmp {
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

struct VS_IN
{
	float4 pos : POSITION;
	float2 uv : TEXCOORD;
};

struct PS_IN
{
	float4 pos : SV_POSITION;
	float2 uv : TEXCOORD;
};

PS_IN VS( VS_IN input )
{
	PS_IN output = (PS_IN)0;
	output.pos = mul( ModelViewProjectionMatrix, input.pos );
	output.uv = input.uv;
	return output;
}

PS_IN VSParticles( VS_IN input, uint vi : SV_VertexID )
{
	PS_IN output = (PS_IN)0;
	float vid = float(vi/4)/10.0f;
	output.pos = mul( ModelViewProjectionMatrix, input.pos + input.uv.x * billUp * 0.5 + input.uv.y * billRight * 0.5 )
	               + float4( sin( timeAmpRtwRth.x + vid ) * timeAmpRtwRth.y, cos(timeAmpRtwRth.x + vid)*timeAmpRtwRth.y, 0.0f, 0.0f ) ;
	output.uv = input.uv;
	return output;
}

float s2lin(float x)
{
    float a = 0.055f;
	if ( x <= 0.04045f )
	{
		return x * (1.0f / 12.92f);
	}
    return pow( (x + a) * (1.0f / (1.0f + a)), 2.4f);
}

float lin2s(float x)
{
    float a = 0.055;
    if ( x <= 0.031308f )
	{
		return x * 12.92f;
	} 
    return (1.0f + a) * pow(x, 1.0f / 2.4f) - a;
}

float4 PS( PS_IN input ) : SV_Target
{
	float4 yo = tex.Sample(TexSmp, input.uv);
	/* Hack until sRGB textures starts working */
//	float bl = input.pos.y/timeAmpRtwRth.w;
	float bl = input.pos.y/720.0f;
	yo = yo * (bl* float4(1.2f,1.4f,1.6f,1.0f) +  (1.0-bl)*float4(1.1f,0.5f,0.2f,1.0f));
//	yo += float4(1.0f,1.0f,1.0f, 1.0f);
	return yo;
}


float4 PSScroller( PS_IN input ) : SV_Target
{
    return float4(0.5f,0.5f,0.5f, 1.0f);
}

/*
	final  = texture(tex, uv - 3.0*TexelSize)*0.06;
	final += texture(tex, uv - 2.0*TexelSize)*0.125;
	final += texture(tex, uv - 1.0*TexelSize)*0.1875;
	final += texture(tex, uv                )*0.25;
	final += texture(tex, uv + 1.0*TexelSize)*0.1875;
	final += texture(tex, uv + 2.0*TexelSize)*0.125;
	final += texture(tex, uv + 3.0*TexelSize)*0.06;
*/

float4 PSGlow( PS_IN input ) : SV_Target
{
#define W4 (1280.0f/2.0f)
#define H4 (1280.0f/2.0f)
#define NS 7.0f
#define MUL (28.0f/NS)
#define NSI 7
	float arr[7] = { 0.06f, 0.125f, 0.1875f, 0.25f, 0.1875f, 0.125f, 0.06f };
	float4 yo = float4( 0.0f, 0.0f, 0.0f, 0.0f );
	float h = MUL*(-NS/2.0f + 0.5f)/H4 + input.uv.y;
	for ( int j = 0; j<NSI; j++ )
	{
		float w = MUL*(-NS/2.0f + 0.5f)/W4 + input.uv.x;
		for ( int i = 0; i<NSI; i++ )
		{
			yo += arr[i]*arr[j]*tex.Sample(TexSmp, float2(w,h));
			w += MUL/W4;
		}
		h += MUL/H4;
	}
//	yo = 3.0f*clamp(yo/(NS*NS)-0.0125f,0.0f,1.0f);
	//float bl = input.pos.y/timeAmpRtwRth.w;
	float bl = input.pos.y/720.0f;
	yo = 6.0f*clamp(yo-0.0125f,0.0f,1.0f) * (bl* float4(0.2f,0.8f,0.7f,1.0f) +  (1.0-bl)*float4(0.1f,0.3f,0.2f,1.0f));
	yo += bl * bl * bl * float4( 0.0f, 0.1f, 0.2f, 1.0f );
	return yo;
}

technique11 Render
{
	pass P0
	{
		SetBlendState( SolidBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthOn, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}

technique11 Glow
{
	pass P0
	{
		SetBlendState( AdditiveBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PSGlow() ) );
	}
}

technique11 Particles
{
	pass P0
	{
		SetBlendState( AdditiveBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthWriteOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VSParticles() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}

technique11 Scroller
{
	pass P0
	{
		SetBlendState( AdditiveBlend, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DepthWriteOff, 0 );
		SetRasterizerState( rasterizerState );
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PSScroller() ) );
	}
}
