#ifdef GL_ES
precision highp float;
#endif

uniform float time;
uniform sampler2D tex0;
uniform vec4 dx0;
uniform vec4 dy0;
uniform vec4 dx1;
uniform vec4 dy1;

void main(void)
{
	const float gap = 0.002;
	float t = time;
	vec2 p = gl_TexCoord[0].xy;
	p.x *= 1.0;
	vec2 d;
	d.x = 0.95*sin(time*dx0.x*dx1.x)*sin(t*dx1.y+p.x*dx0.y)*cos(t*dx1.z+p.x*dx0.z)*cos(t*dx1.w+p.x*dx0.w);
	d.y = 0.95*sin(time*dx0.x*dx1.x)*cos(t*dx1.y+p.x*dx0.y)*sin(t*dx1.z+p.x*dx0.z)*sin(t*dx1.w+p.x*dx0.w);
//	d.y = 0.95*cos(time*dy0.x*dy1.x)*cos(t*dy1.y+p.x*dy0.y)*sin(t*dy1.z+p.x*dy0.z)*sin(t*dy1.w+p.x*dy0.w);
	p += d;
	float l = 0.125/sqrt(d.x*d.x+d.y*d.y);
	l *=l*l*l;
	l = min(l,1.0)*0.125;


	vec2 p0 = p;
	p0.x += 2.0*gap;

	float nx = texture2D(tex0,p0).x;

	p0.x -= 2.0*gap;
	nx -= texture2D(tex0,p0).x;


	p0.x += 1.0*gap;
	p0.y += 1.0*gap;

	float ny = texture2D(tex0,p0).x;
	p0.y -= 2.0*gap;
	ny -= texture2D(tex0,p0).x;

	nx += 0.5*sin(time*0.01);
	ny += 0.5*cos(time*0.01);
	float bl = l/sqrt(nx*nx+ny*ny);
	bl *= bl;
	if (bl>1.0) bl=1.0;




	gl_FragColor = texture2D(tex0, p.xy)*(bl+l);
	//gl_FragColor = vec4(p,1.0,1.0);

}


void working_main(void)
{
	float t = time;
	vec2 p = gl_TexCoord[0].xy;
	p.x *= 1.0;
	vec2 d;
	d.x = 0.95*sin(time*dx0.x*dx1.x)*sin(t*dx1.y+p.x*dx0.y)*cos(t*dx1.z+p.x*dx0.z)*cos(t*dx1.w+p.x*dx0.w);
	d.y = 0.95*sin(time*dx0.x*dx1.x)*cos(t*dx1.y+p.x*dx0.y)*sin(t*dx1.z+p.x*dx0.z)*sin(t*dx1.w+p.x*dx0.w);
//	d.y = 0.95*cos(time*dy0.x*dy1.x)*cos(t*dy1.y+p.x*dy0.y)*sin(t*dy1.z+p.x*dy0.z)*sin(t*dy1.w+p.x*dy0.w);
	p += d;
	float l = 0.125/sqrt(d.x*d.x+d.y*d.y);
	l *=l*l*l;
	l = min(l,1.0)-0.5;




	gl_FragColor = texture2D(tex0, p.xy)+(l);
	//gl_FragColor = vec4(p,1.0,1.0);

}

void old_main(void)
{
	float t = time;
	vec2 p = gl_TexCoord[0].xy;
	p.x *= 1.0;
	vec2 d;
	d.x = 0.95*sin(time*0.05)*sin(-t*0.15+p.x*10.0)*cos(t*0.25+p.x*2.0)*cos(t*0.125+p.x*1.0);
	d.y = 0.5*sin(time*0.15)*cos(t*0.75+p.y*6.0)*sin(-t*0.8+p.y*3.0)*cos(t*0.125+p.y*15.0);
	p += d;
	float l = 0.125/sqrt(d.x*d.x+d.y*d.y);
	l *=l*l*l;
	l = min(l,5.0);
	gl_FragColor = texture2D(tex0, p.xy)*(l+0.01);
	//gl_FragColor = vec4(p,1.0,1.0);

}

void stupid_bloom(void)
{
	vec4 c = texture2D(tex0, gl_TexCoord[0].xy);
	float gap = 0.0125;
	

	
	float yp = -2.5*gap;
	for (int y=0; y<5; y++)
	{
		float xp = -2.5*gap;
		for (int x=0; x<5; x++)
		{
			vec2 p0;
			p0 = gl_TexCoord[0].xy;
			p0.x += xp;
			p0.y += yp;
			float scalar = 0.00125/sqrt(xp*xp+yp*yp);
			c += texture2D(tex0, p0.xy)*scalar;
			xp += gap;
		}
		yp += gap;
	}
	gl_FragColor = c;
}