#include version.txt

uniform sampler2D velocities_u;
uniform sampler2D velocities_v;
uniform float buffer_size;

void main() {	
    
    float step = 1.0 / buffer_size;
    
    vec4 u_sample = texture2D(velocities_u, gl_TexCoord[0].xy + vec2(step, 0.0)) - texture2D(velocities_u, gl_TexCoord[0].xy - vec2(step, 0.0));
    vec4 v_sample = texture2D(velocities_v, gl_TexCoord[0].xy + vec2(0.0, step)) - texture2D(velocities_v, gl_TexCoord[0].xy - vec2(0.0, step));
    
	gl_FragColor = vec4(-0.5) * vec4(step) * (u_sample + v_sample);
}
