SetupFullscreen(1280, 720, "Panda");

introLayer = new Layer();
introLayer.SetBlendMode(BlendModeReplace);
introBilde = new Quad(introLayer, 0,0, 1280, 720); 
introBilde.SetImage("data/text1.png");
introBilde2 = new Quad(introLayer, 0,0, 1280, 720); 
introBilde2.SetImage("data/text2.png");
introBilde.SetSize(0, 0);
introBilde2.SetSize(0, 0);
music = new AudioStream("data/FauxClef-demotune1.ogg");
music2  = new AudioStream("data/FauxClef-demotune1.ogg");
textLayer = new Layer();
textLayer.SetBlendMode(BlendModeReplace);
text = [];
for (i=0;i < 19;i++){
	text[i] = new Quad(textLayer, 0, 0, 1280, 720);
	text[i].SetImage("data/text"+(3+i)+".png");
	text[i].SetSize(0, 0);
}

bakgrunnLayer = new Layer();
bakgrunnLayer.SetBlendMode(BlendModeReplace);
bakgrunnBilde = new Quad(bakgrunnLayer, 0, 0, 1280, 720);
bakgrunnBilde.SetImage("data/bg1.png");
bakgrunnBilde.SetSize(0, 0);
bakgrunnBilde2 = new Quad(bakgrunnLayer, 0, 0, 1280, 720);
bakgrunnBilde2.SetImage("data/bg2.png");
bakgrunnBilde2.SetSize(0, 0);


drinkingLayer = new Layer();
drinkingLayer.SetBlendMode(BlendModeReplace);
//drinkingBG = new Quad(drinkingLayer, 0 , 0, 1280, 720);
//drinkingBG.SetColor("0xffffff");
drinking = [];
drinking[0] = new Quad(drinkingLayer, 0, 0, 1280, 720);
drinking[1] = new Quad(drinkingLayer, 0, 0, 1280, 720);
drinking[0].SetImage("data/pandadrinking1.png");
drinking[1].SetImage("data/pandadrinking2.png");
drinking[0].SetSize(0,0);
drinking[1].SetSize(0,0);

bananaLayer = new Layer();
bananaLayer.SetBlendMode(BlendModeReplace);
bananaBilde = new Quad(bananaLayer, 350, 100, 500, 500);
bananaBilde.SetImage("data/takeabanana.png");

kegLayer = new Layer();
kegLayer.SetBlendMode(BlendModeReplace);
kegBilde = [];
for (i=0; i < 2 ;i++) {
	kegBilde[i] = new Quad(kegLayer, 0, 0, 400, 200);
	kegBilde[i].SetImage("data/keg"+i+".png");
	kegBilde[i].SetSize(0, 0);
}

pandaLayer = new Layer();
pandaLayer.SetBlendMode(BlendModeReplace);
pandas = [];
for (i=0; i < 9; i++)
{
	pandas[i] = new Quad(pandaLayer, 0, 0, 400, 250);
	pandas[i].SetImage("data/panda"+i+".png");
	pandas[i].SetSize(0,0);
	pandas[i].SetPosition(0,0);
}

monkeyLayer = new Layer();
monkeyLayer.SetBlendMode(BlendModeReplace);
monkey = [];
for (i=0; i < 3; i++)
{
	monkey[i] = new Quad(monkeyLayer, 0, 0, 500, 500);
	monkey[i].SetImage("data/monkey"+i+".png");
	monkey[i].SetSize(0, 0);
}

function drawPanda(time){
	p = Math.round(time*12)%9;
	pandas[p].SetSize(500, 300);
	pandas[p].SetPosition(-380 + (time*100)%1900, 390+8*(Math.sin(16*time)-Math.cos(16*time)*Math.cos(16*time)));
	pandaLayer.Render();
	pandas[p].SetSize(0, 0);
}
function drawKeg(){
	p = Math.round(time*5)%2;
	kegBilde[p].SetSize(500, 500);
	kegBilde[p].SetPosition(500, 120);
	//kegBilde[p].Rotate(-2.0+time%1.02);
	if (time-10%37 > 18) kegLayer.Render();
	kegBilde[p].SetSize(0, 0);
}

function drawMonkey()
{
	p = Math.round(time*9)%3;
	monkey[p].SetSize(500, 500);
	monkey[p].SetPosition(500, 120);
	monkeyLayer.Render();
	monkey[p].SetSize(0, 0);
}

function drawText(n){
	text[n].SetSize(1280, 720);
	textLayer.Render();
	text[n].SetSize(0, 0);
}

function drawBG(time){
	if (time%37 < 18) bakgrunnBilde.SetSize(1280, 720);
	else if (time%37 < 60) bakgrunnBilde2.SetSize(1280, 720);
	bakgrunnLayer.Render();
	bakgrunnBilde.SetSize(0, 0);
	bakgrunnBilde2.SetSize(0, 0);
}

function drawBanana(){
	bananaBilde.SetSize(500+70*Math.sin(time*12), 500+70*Math.sin(time*12));
	bananaLayer.Render();
}

finnLayer = new Layer();
finnLayer.SetBlendMode(BlendModeReplace);
finn = [];
for (i = 0;i<2;i++){
	finn[i] = new Quad(finnLayer, 350, 120, 500, 500);
	finn[i].SetImage("data/poo"+(i+1)+".png");
	finn[i].SetSize(0, 0);
}

function drawFinn(){
	p = Math.round(time*2)%2;
	finn[p].SetSize(500, 500);
	finnLayer.Render();
	finn[p].SetSize(0, 0);
}

bassLayer = new Layer();
bassLayer.SetBlendMode(BlendModeReplace);
bass = [];
for (i = 0;i<3;i++){
	bass[i] = new Quad(bassLayer, 450, 120, 500, 500);
	bass[i].SetImage("data/bass"+(i+1)+".png");
	bass[i].SetSize(0, 0);
}

function drawBass(){
	p = Math.round(time*4)%3;
	bass[p].SetSize(500, 500);
	bassLayer.Render();
	bass[p].SetSize(0, 0);
}



intro_layer = new Layer();

w = 1280;
h = 720;

function noise()
{
	v = [];
	for(var i =0; i<w; i++)
	{
		v[i] = [];
		for(var j = 0; j<h; j++)
		{
			v[i][j] = Math.random();
		}
	}	
	return v;
}
function sample(v, x, y)
{

	while(x<0) x+=w;
	while(y<0) y+=h;
	
	x%=w;
	y%=h;
	
	//if(x<0) x = 0;
	//if(y<0) y = 0;
	//if(x>=w) x = w-1;
	//if(y>=h) y = h-1;
	
	return v[x][y];
	
}

function blur(v)
{
	var r = [];
	for(var i=0; i<w; i++)
	{
		r[i] = [];
		for(var j=0; j<h; j++)
		{
			r[i][j] = (sample(v, i, j)*4 + sample(v, i-1, j) + sample(v, i+1, j) + sample(v, i, j-1) + sample(v, i, j+1))/8;
		}
	}
	return r;
}

function add(a, b)
{
	var array = [];
	for(var i = 0; i<w; i++){
		array[i] = [];
		for(var j = 0; j<h; j++)
		{
			array[i][j] = a[i][j]+b[i][j];
		}
	}
	return array;
}

function mul(a, k)
{
	var array = [];
	for(var i = 0; i<w; i++){
		array[i] = [];
		for(var j = 0; j<h; j++)
		{
			array[i][j] = a[i][j]*k;
		}
	}
	return array;
}


function perlinNoise() 
{
	var v = noise();
	for(var i = 1; i<5; i++){
		v = blur(blur(v));
		var n = noise();
		n = mul(n, 1.0/Math.pow(i+1.0,1.5));
		v = add(v, n);
	}
	return blur(blur(blur(blur(v))));	
}

var n = perlinNoise();

pixelQuad = [];
	for(var i =0; i<128; i++){
		pixelQuad[i] = [];
		for(var j = 0; j<72; j++){
			pixelQuad[i][j] = new Quad(intro_layer, i*10, j*10, 10, 10);
		}
	}
	
//music.Play();
repeat = true;
start = true;
function drawDrinking(){
	p = Math.round(time*5)%2;
	drinking[p].SetSize(1280, 720);
	drinkingLayer.Render();
	drinking[p].SetSize(0,0);
}
function drawTween(){
	if ((time > 31 && /*time < 34) || (time > 36 && time < 38) || (time > 54 && */time < 61)) drawKeg();
	if ((time > 61 && /*time < 63) || (time > 65 && time < 67) || (time > 74 && */time < 79)) drawMonkey();
	if ((time > 79 && /*time < 85) || (time > 89 &&*/ time < 98)) drawFinn();
	if ((time > 98 && /*time < 106) || (time > 110 && */time < 114)) drawBass();
}

while(Update() && !KeyDown(KeyEsc))
{
	time = GetTime()-10;
	if (start) {
		music.PlayLoop();
		start = false;
	}
	/*if (repeat && time > 63) {
		repeat = false;
		music.Stop();
		music2.Play();
	}*/
	
	if (time < 10)
	{
		if (time > 8) drawText(11);
		else {
			if (time > 5) introBilde2.SetSize(1280, 720);
			else introBilde.SetSize(1280, 720);
			introLayer.Render();
			introBilde.SetSize(0, 0);
			introBilde2.SetSize(0, 0);
		}
	}
	else if (time < 126)
	{
		
		if (time < 13) {
			drawBG(time-10);
			drawTween();
			drawPanda(time-10);
		}
		else if (time < 16) drawText(1);
		else if (time < 20) drawText(3);
		else if (time < 24) {
			drawBG(time-15);
			drawTween();
			drawPanda(time-15);
		}
		else if (time < 28) drawText(0);
		else if (time < 31) drawText(2);
		else if (time < 34) {
			drawBG(time-13);
			drawTween();
			drawPanda(time-13);
		}
		else if (time > 34 && time < 36) drawText(4);
		else if (time > 36 && time < 38) {
			drawBG(time-13);
			drawTween();
			drawPanda(time-13);
		}
		else if (time > 38 && time < 40) drawText(5);
		else if (time > 40 && time < 44) {
			//drawBG(time-14);
			drawDrinking();
			drinkingLayer.Render();
		}
		else if (time > 44 && time < 54){
			intro_layer.Render();
			for(var i =0; i<128; i++){
				for(var j = 0; j<72; j++){
					k = sample(n, Math.floor(i+Math.sin(j*0.05+time)*10), Math.floor(j+Math.sin(j*0.05+time)*10));
					k *= sample(n, Math.floor(i+Math.sin(j*0.105+time)*10), Math.floor(j+Math.sin(j*0.15+time)*10));
					var r = Math.sin(k*29.4+time)*0.5+0.5;
					var g = Math.sin(k*17.4+time)*0.5+0.5;
					var b = Math.sin(k*17.4+time)*0.5+0.5;
					
					pixelQuad[i][j].SetColor(r,g,b,1);
				}
			}
		}
		else if (time > 54 && time < 63){
			drawBG(time-24);
			drawTween();
			drawPanda(time-24);
		}
		else if (time > 63 && time < 65) drawText(6);
		else if (time > 67 && time < 70) drawText(7);
		else if ( (time > 70 && time < 74))
		{
			drawBG(time-24);
			//drawTween();
			drawBanana();
		}
		else if (time > 74 && time < 76) drawText(8);//oh thank you
		else if (time > 83 && time < 87) drawText(10);//poo
		else if (time > 93 && time < 97) drawText(17);//that way
		else if (time > 103 && time < 107) drawText(9);//bass
		else if (time > 109 && time < 111) drawText(16);
		else if (time > 111 && time < 114) {
			drawBG(time-24);
			drawBanana();
		}
		else if (time < 112) {
			drawBG(time-24);
			drawTween();
			drawPanda(time-24);
		}
		else if (time > 114){
			if (time > 122) drawText(14);
			else if (time > 120) drawText(12);
			else if (time > 118) drawText(18);
			else if (time > 116) drawText(11);
			else if (time > 114) drawText(13);
		}
		//drawPanda();
	}
	else break;
}
	