#version 330
#define GL_core_profile 1

in vec3 fNormal; // fragment normal (N)
in vec3 V;
in vec3 lightDirection;
in vec3 eyeVector;
in vec3 vColor;

out vec3 color;

const vec3 ambient = vec3(0.076, 0.075, 0.075);
const vec3 diffuse = vec3(0.31, 0.3, 0.3);

void main(void)
{
	color = ambient * vColor;
	vec3 N = normalize(fNormal);
	vec3 L = normalize(lightDirection);
	float lambertTerm = dot(N, L);

	if (lambertTerm > 0.0) {
		color += vColor * lambertTerm;
	}
}
