#version 330

in vec2 fTex;

out vec4 oCol;

uniform sampler2D sTexture;
uniform sampler2D sNoise;
uniform float blink;
uniform vec2 noiseSamplerOffset;

// layout(origin_upper_left, pixel_center_integer) in vec4 gl_FragCoord;
// layout(pixel_center_integer) in vec4 gl_FragCoord;

const float aspectRatio = 1.6;
const float Pi = 3.14159265;
const float ToPi = 2 * Pi;
const vec2 pixels[13] = vec2[13](vec2( -6, -6 ),vec2( -5, -5 ),vec2( -4, -4 ),vec2( -3, -3 ),vec2( -2, -2 ),vec2( -1, -1 ),vec2(  0, 0 ),vec2(  1, 1 ),vec2(  2, 2 ),vec2(  3, 3 ),vec2(  4, 4 ),vec2(  5, 5 ),vec2(  6, 6 ));
//const vec2 pixels[13] = vec2[13](vec2(0, 2), vec2(-1, 1), vec2(0, 1), vec2(1, 1), vec2(-2, 0), vec2(-1, 0), vec2(0, 0), vec2(-1, 0), vec2(-2, 0), vec2(-1, -1), vec2(0, -1), vec2(1, -1), vec2(0, -2));
const float weights[13] =
float[13](
    0.002216,
    0.008764,
    0.026995,
    0.064759,
    0.120985,
    0.176033,
    0.199471,
    0.176033,
    0.120985,
    0.064759,
    0.026995,
    0.008764,
    0.002216
);


void main(void)
{
	
	//vec2 distCoord = -sin(ToPi*fTex) / 8.0 + fTex;
	
	vec2 pVec = fTex - 0.5;
	float radius = 0.4 * (pVec.x * pVec.x) / (-0.8 * -0.8) + aspectRatio * (pVec.y * pVec.y) / (0.8 * 0.8);
	//radius = blink - smoothstep(0.1, 0.90, radius);
	//radius = smoothstep(0.1, 0.90, blink - radius);
	radius = smoothstep(0.0, 1.0, blink - radius);
	
	vec3 col = vec3(0.0);
	vec3 lol = texture(sTexture, fTex).rgb;
	vec3 n = vec3(texture(sNoise, fTex + noiseSamplerOffset).r);
	

	for (int i = 0; i < 13; ++i) {
		col += texture(sTexture, fTex + pixels[i] * 0.00025).rgb * weights[i];
	}
	
	vec3 noiseFactor = vec3(0.915);
	
	
	vec3 rgb = col * vec3(radius) * (noiseFactor * lol  + vec3((1.0 - noiseFactor) * n));
	/*
	vec3 rgb = vec3(radius) * 
				( lol * col * noiseFactor
			    + vec3( (1.0 - noiseFactor)) * texture(sNoise, fTex + noiseSamplerOffset).r
				);
	*/
	oCol = vec4(rgb, 1.0);
}