/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.glgraphics;

import codeanticode.glgraphics.GLState;
import codeanticode.glgraphics.GLTextureGrid;
import codeanticode.glgraphics.GLTexturedPoint;
import codeanticode.glgraphics.GLUtils;
import com.sun.opengl.util.BufferUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import processing.xml.XMLElement;

public class GLTextureGridCompiled
extends GLTextureGrid {
    protected boolean built;
    protected int mode;
    protected int width;
    protected int height;
    protected int resX;
    protected int resY;
    protected GLTexturedPoint[] points;
    protected int numLayers;
    protected int vertCoordsVBO;
    protected int[] texCoordsVBO;
    protected int numVertices;
    protected int numTexCoords;
    protected int numTextures;

    public GLTextureGridCompiled(GL gL) {
        super(gL);
        this.initGrid();
        this.height = 0;
        this.width = 0;
        this.built = false;
    }

    public void delete() {
        this.releaseGrid();
    }

    public GLTextureGridCompiled(GL gL, XMLElement xMLElement) {
        super(gL);
        this.initGrid(xMLElement);
        this.height = 0;
        this.width = 0;
        this.built = false;
    }

    public void render(int n, int n2, int n3, int n4, int n5) {
        if (!this.built || this.usingSrcTexRes && (n != this.width || n2 != this.height) || !this.usingSrcTexRes && (n3 != this.width || n4 != this.height)) {
            if (this.usingSrcTexRes) {
                this.buildGrid(n, n2);
            } else {
                this.buildGrid(n3, n4);
            }
        }
        this.gl.glEnableClientState(32884);
        this.gl.glEnableClientState(32888);
        for (int i = 0; i < this.numTextures; ++i) {
            this.gl.glClientActiveTexture(33984 + i);
            this.gl.glBindBufferARB(34962, this.texCoordsVBO[i]);
            this.gl.glTexCoordPointer(2, 5126, 0, 0L);
        }
        this.gl.glBindBufferARB(34962, this.vertCoordsVBO);
        this.gl.glVertexPointer(3, 5126, 0, 0L);
        this.gl.glDrawArrays(this.mode, 0, this.numVertices);
        this.gl.glDisableClientState(32884);
        this.gl.glDisableClientState(32888);
    }

    protected void initGrid() {
        this.numLayers = 1;
        this.resY = 2;
        this.resX = 2;
        this.mode = 0;
        this.points = new GLTexturedPoint[1];
        this.points[0] = new GLTexturedPoint();
        this.points[0].setAsUndefined();
    }

    protected void initGrid(XMLElement xMLElement) {
        int n = xMLElement.getChildCount();
        this.numLayers = n == 1 ? 1 : n - 1;
        this.points = new GLTexturedPoint[this.numLayers];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string = xMLElement2.getName();
            if (string.equals("resolution")) {
                String string2 = xMLElement2.getStringAttribute("nx");
                String string3 = xMLElement2.getStringAttribute("ny");
                this.usingSrcTexRes = false;
                this.resX = string2.equals("w") ? 0 : (string2.equals("w0") ? -1 : (string2.equals("w1") ? -2 : (string2.equals("w2") ? -3 : (string2.equals("w3") ? -4 : (string2.equals("w4") ? -5 : (string2.equals("w5") ? -6 : xMLElement2.getIntAttribute("nx")))))));
                this.resY = string3.equals("h") ? 0 : (string3.equals("h0") ? -1 : (string3.equals("h1") ? -2 : (string3.equals("h2") ? -3 : (string3.equals("h3") ? -4 : (string3.equals("h4") ? -5 : (string3.equals("h5") ? -6 : xMLElement2.getIntAttribute("ny")))))));
                if (this.resX <= 0 || this.resY <= 0) {
                    if (this.resX != this.resY) {
                        System.err.println("Source width and height are different!");
                    } else if (this.resX < 0) {
                        this.usingSrcTexRes = true;
                        this.srcTexIdx = -(this.resX + 1);
                    }
                }
                String string4 = xMLElement2.getStringAttribute("mode");
                this.mode = GLUtils.parsePrimitive(string4);
                continue;
            }
            if (!string.equals("point")) continue;
            this.points[n2] = new GLTexturedPoint(xMLElement2);
            ++n2;
        }
        if (n == 1) {
            this.points[0] = new GLTexturedPoint();
            this.points[0].setAsUndefined();
        }
    }

    protected void buildGrid(int n, int n2) {
        float f;
        float f2;
        int n3;
        int n4;
        if (this.built) {
            this.releaseGrid();
        }
        int n5 = this.resX;
        int n6 = this.resY;
        if (n5 <= 0) {
            n5 = n;
        }
        if (n6 <= 0) {
            n6 = n2;
        }
        this.numTextures = 100;
        for (n4 = 0; n4 < this.numLayers; ++n4) {
            if (this.points[n4].s.length >= this.numTextures) continue;
            this.numTextures = this.points[n4].s.length;
        }
        this.numVertices = n5 * n6 * this.numLayers;
        this.numTexCoords = n5 * n6 * this.numLayers;
        FloatBuffer floatBuffer = BufferUtil.newFloatBuffer((int)(this.numVertices * 3));
        FloatBuffer[] floatBufferArray = new FloatBuffer[this.numTextures];
        for (n3 = 0; n3 < this.numTextures; ++n3) {
            floatBufferArray[n3] = BufferUtil.newFloatBuffer((int)(this.numTexCoords * 2));
        }
        if (this.mode == 3 || this.mode == 2 || this.mode == 5 || this.mode == 6 || this.mode == 8) {
            f2 = 1 < n5 ? 1.0f / (float)(n5 - 1) : 1.0f;
            f = 1 < n6 ? 1.0f / (float)(n6 - 1) : 1.0f;
        } else {
            f2 = 1.0f / (float)n5;
            f = 1.0f / (float)n6;
        }
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                for (n4 = 0; n4 < this.numLayers; ++n4) {
                    float f3 = (float)j * f2;
                    float f4 = (float)i * f;
                    float f5 = this.points[n4].x;
                    float f6 = this.points[n4].y;
                    float f7 = this.points[n4].dx;
                    float f8 = this.points[n4].dy;
                    if (f5 == -1.0f) {
                        f5 = f3 * (float)n;
                    }
                    if (f6 == -1.0f) {
                        f6 = f4 * (float)n2;
                    }
                    if (f7 == -1.0f) {
                        f7 = f2 * (float)n;
                    }
                    if (f8 == -1.0f) {
                        f8 = f * (float)n2;
                    }
                    floatBuffer.put(f5 + f7);
                    floatBuffer.put(f6 + f8);
                    floatBuffer.put(0.0f);
                    for (n3 = 0; n3 < this.numTextures; ++n3) {
                        float f9 = this.points[n4].s[n3];
                        float f10 = this.points[n4].t[n3];
                        float f11 = this.points[n4].ds[n3];
                        float f12 = this.points[n4].dt[n3];
                        if (f9 == -1.0f) {
                            f9 = f3;
                        }
                        if (f10 == -1.0f) {
                            f10 = f4;
                        }
                        if (f11 == -1.0f) {
                            f11 = f2;
                        }
                        if (f12 == -1.0f) {
                            f12 = f;
                        }
                        floatBufferArray[n3].put(f9 + f11);
                        floatBufferArray[n3].put(f10 + f12);
                    }
                }
            }
        }
        floatBuffer.flip();
        for (n3 = 0; n3 < this.numTextures; ++n3) {
            floatBufferArray[n3].flip();
        }
        this.texCoordsVBO = new int[this.numTextures];
        this.vertCoordsVBO = GLState.createGLResource(1);
        this.gl.glBindBufferARB(34962, this.vertCoordsVBO);
        this.gl.glBufferDataARB(34962, this.numVertices * 3 * 4, (Buffer)floatBuffer, 35044);
        for (n3 = 0; n3 < this.numTextures; ++n3) {
            this.texCoordsVBO[n3] = GLState.createGLResource(1);
            this.gl.glBindBufferARB(34962, this.texCoordsVBO[n3]);
            this.gl.glBufferDataARB(34962, this.numTexCoords * 2 * 4, (Buffer)floatBufferArray[n3], 35044);
        }
        this.built = true;
        this.width = n;
        this.height = n2;
    }

    protected void releaseGrid() {
        if (this.vertCoordsVBO != 0) {
            GLState.deleteGLResource(this.vertCoordsVBO, 1);
        }
        if (0 < this.numTextures) {
            for (int i = 0; i < this.numTextures; ++i) {
                GLState.deleteGLResource(this.texCoordsVBO[i], 1);
            }
        }
    }
}

