/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.glgraphics;

import codeanticode.glgraphics.GLConstants;
import codeanticode.glgraphics.GLState;
import codeanticode.glgraphics.GLTexture;
import com.sun.opengl.cg.CGcontext;
import com.sun.opengl.cg.CGeffect;
import com.sun.opengl.cg.CGparameter;
import com.sun.opengl.cg.CGpass;
import com.sun.opengl.cg.CGtechnique;
import com.sun.opengl.cg.CgGL;
import javax.media.opengl.GL;
import processing.core.PApplet;
import processing.opengl.PGraphicsOpenGL;

public class GLCgFXEffect
implements GLConstants {
    protected PApplet parent;
    protected CGcontext context;
    protected CGeffect effect;
    protected CGtechnique currTechnique;
    protected CGpass currPass;
    protected GL gl;

    public GLCgFXEffect(PApplet pApplet, String string) {
        this.parent = pApplet;
        PGraphicsOpenGL pGraphicsOpenGL = (PGraphicsOpenGL)pApplet.g;
        this.gl = pGraphicsOpenGL.gl;
        this.context = (CGcontext)GLState.createCGResource(6);
        this.checkCgError();
        CgGL.cgGLRegisterStates((CGcontext)this.context);
        CgGL.cgGLSetManageTextureParameters((CGcontext)this.context, (boolean)true);
        this.load(string);
    }

    public void delete() {
        this.release();
    }

    public CGeffect getEffect() {
        return this.effect;
    }

    public void start() {
    }

    public void stop() {
    }

    public void setFirstTechnique() {
        this.currTechnique = CgGL.cgGetFirstTechnique((CGeffect)this.effect);
        if (this.currTechnique == null) {
            System.err.println("GLCgFXEffect:  technique is null");
        }
    }

    public void setTechnique(String string) {
        this.currTechnique = CgGL.cgGetNamedTechnique((CGeffect)this.effect, (String)string);
        if (this.currTechnique == null) {
            System.err.println("GLCgFXEffect:  technique '" + string + "' is null");
        }
    }

    public void setSelectedPass() {
        if (this.currPass != null) {
            CgGL.cgSetPassState((CGpass)this.currPass);
        }
    }

    public void resetSelectedPass() {
        CgGL.cgResetPassState((CGpass)this.currPass);
    }

    public boolean selectFirstPass() {
        this.currPass = CgGL.cgGetFirstPass((CGtechnique)this.currTechnique);
        return this.currPass != null;
    }

    public boolean selectNextPass() {
        this.currPass = CgGL.cgGetNextPass((CGpass)this.currPass);
        return this.currPass != null;
    }

    public void setTexParameter(String string, GLTexture gLTexture) {
        int n = gLTexture.getTextureID();
        CGparameter cGparameter = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetTextureParameter((CGparameter)cGparameter, (int)n);
        } else {
            System.err.println("GLCgFXEffect:  Cant find texture parameter");
        }
        CgGL.cgSetSamplerState((CGparameter)cGparameter);
    }

    public void setIntParameter(String string, int n) {
        CGparameter cGparameter = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgSetParameter1i((CGparameter)cGparameter, (int)n);
        } else {
            System.err.println("GLCgFXEffect:  param1f is null");
        }
    }

    public void setFloatParameter(String string, float f) {
        CGparameter cGparameter = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgSetParameter1f((CGparameter)cGparameter, (float)f);
        } else {
            System.err.println("GLCgFXEffect:  param1f is null");
        }
    }

    public void setVecParameter(String string, float f, float f2) {
        CGparameter cGparameter = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgSetParameter2f((CGparameter)cGparameter, (float)f, (float)f2);
        } else {
            System.err.println("GLCgFXEffect:  param2f is null");
        }
    }

    public void setVecParameter(String string, float f, float f2, float f3) {
        CGparameter cGparameter = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgSetParameter3f((CGparameter)cGparameter, (float)f, (float)f2, (float)f3);
        } else {
            System.err.println("GLCgFXEffect:  param3f is null");
        }
    }

    public void setVecParameter(String string, float f, float f2, float f3, float f4) {
        CGparameter cGparameter = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgSetParameter4f((CGparameter)cGparameter, (float)f, (float)f2, (float)f3, (float)f4);
        } else {
            System.err.println("GLCgFXEffect:  param4f is null");
        }
    }

    public void setMatParameter(String string, float f, float f2, float f3, float f4) {
        CGparameter cGparameter = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            float[] fArray = new float[4];
            fArray[0] = f;
            fArray[1] = f3;
            fArray[4] = f2;
            fArray[5] = f4;
            CgGL.cgGLSetMatrixParameterfr((CGparameter)cGparameter, (float[])fArray, (int)0);
        } else {
            System.err.println("GLCgFXEffect:  matrix2x2f param is null");
        }
    }

    public void setMatParameter(String string, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        CGparameter cGparameter = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            float[] fArray = new float[9];
            fArray[0] = f;
            fArray[1] = f4;
            fArray[2] = f7;
            fArray[4] = f2;
            fArray[5] = f5;
            fArray[6] = f8;
            fArray[8] = f3;
            fArray[9] = f6;
            fArray[10] = f9;
            CgGL.cgGLSetMatrixParameterfr((CGparameter)cGparameter, (float[])fArray, (int)0);
        } else {
            System.err.println("GLCgFXEffect:  matrix3x3f param is null");
        }
    }

    public void setMatParameter(String string, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        CGparameter cGparameter = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            float[] fArray = new float[]{f, f5, f9, f13, f2, f6, f10, f14, f3, f7, f11, f15, f4, f8, f12, f16};
            CgGL.cgGLSetMatrixParameterfr((CGparameter)cGparameter, (float[])fArray, (int)0);
        } else {
            System.err.println("GLCgFXEffect:  matrix4x4f param is null");
        }
    }

    public void setModelviewMatrix(String string) {
        CGparameter cGparameter = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)cGparameter, (int)4, (int)0);
        } else {
            System.err.println("GLCgFXEffect:  cgGLSetStateMatrixParameter semantic param is null");
        }
    }

    public void setProjectionMatrix(String string) {
        CGparameter cGparameter = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)cGparameter, (int)5, (int)0);
        } else {
            System.err.println("GLCgFXEffect:  cgGLSetStateMatrixParameter semantic param is null");
        }
    }

    public void setModelviewProjectionMatrix(String string) {
        CGparameter cGparameter = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)cGparameter, (int)7, (int)0);
        } else {
            System.err.println("GLCgFXEffect:  cgGLSetStateMatrixParameter semantic param is null");
        }
    }

    public void setTexMatrix(String string) {
        CGparameter cGparameter = CgGL.cgGetNamedEffectParameter((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)cGparameter, (int)6, (int)0);
        } else {
            System.err.println("GLCgFXEffect:  cgGLSetStateMatrixParameter semantic param is null");
        }
    }

    public void setMatrixParameterBySemantic(String string, int n) {
        this.setMatrixParameterBySemantic(string, n, 0);
    }

    public void setMatrixParameterBySemantic(String string, int n, int n2) {
        CGparameter cGparameter = CgGL.cgGetEffectParameterBySemantic((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)cGparameter, (int)n, (int)this.getCgMatrixTransform(n2));
        } else {
            System.err.println("GLCgFXEffect:  cgGLSetStateMatrixParameter(mat, type) is null");
        }
    }

    public void setModelviewMatrixBySemantic(String string) {
        this.setModelviewMatrixBySemantic(string, 0);
    }

    public void setModelviewMatrixBySemantic(String string, int n) {
        CGparameter cGparameter = CgGL.cgGetEffectParameterBySemantic((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)cGparameter, (int)4, (int)this.getCgMatrixTransform(n));
        } else {
            System.err.println("GLCgFXEffect:  cgGLSetStateMatrixParameter(mat, type) is null");
        }
    }

    public void setProjectionMatrixBySemantic(String string) {
        this.setProjectionMatrixBySemantic(string, 0);
    }

    public void setProjectionMatrixBySemantic(String string, int n) {
        CGparameter cGparameter = CgGL.cgGetEffectParameterBySemantic((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)cGparameter, (int)5, (int)this.getCgMatrixTransform(n));
        } else {
            System.err.println("GLCgFXEffect:  cgGLSetStateMatrixParameter(mat, type) is null");
        }
    }

    public void setModelviewProjectionMatrixBySemantic(String string) {
        this.setModelviewProjectionMatrixBySemantic(string, 0);
    }

    public void setModelviewProjectionMatrixBySemantic(String string, int n) {
        CGparameter cGparameter = CgGL.cgGetEffectParameterBySemantic((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)cGparameter, (int)7, (int)this.getCgMatrixTransform(n));
        } else {
            System.err.println("GLCgFXEffect:  cgGLSetStateMatrixParameter(mat, type) is null");
        }
    }

    public void setTextureMatrixBySemantic(String string) {
        this.setTextureMatrixBySemantic(string, 0);
    }

    public void setTextureMatrixBySemantic(String string, int n) {
        CGparameter cGparameter = CgGL.cgGetEffectParameterBySemantic((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetStateMatrixParameter((CGparameter)cGparameter, (int)6, (int)this.getCgMatrixTransform(n));
        } else {
            System.err.println("GLCgFXEffect:  cgGLSetStateMatrixParameter(mat, type) is null");
        }
    }

    public void setTexParameterBySemantic(String string, GLTexture gLTexture) {
        int n = gLTexture.getTextureID();
        CGparameter cGparameter = CgGL.cgGetEffectParameterBySemantic((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetTextureParameter((CGparameter)cGparameter, (int)n);
        } else {
            System.err.println("GLCgFXEffect:  Cant find texture semantic");
        }
        CgGL.cgSetSamplerState((CGparameter)cGparameter);
    }

    public void setIntParameterBySemantic(String string, int n) {
        CGparameter cGparameter = CgGL.cgGetEffectParameterBySemantic((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgSetParameter1i((CGparameter)cGparameter, (int)n);
        } else {
            System.err.println("GLCgFXEffect:  1f semantic is null");
        }
    }

    public void setFloatParameterBySemantic(String string, float f) {
        CGparameter cGparameter = CgGL.cgGetEffectParameterBySemantic((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgSetParameter1f((CGparameter)cGparameter, (float)f);
        } else {
            System.err.println("GLCgFXEffect: 1f  semantic is null");
        }
    }

    public void setVecParameterBySemantic(String string, float f, float f2) {
        CGparameter cGparameter = CgGL.cgGetEffectParameterBySemantic((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgSetParameter2f((CGparameter)cGparameter, (float)f, (float)f2);
        } else {
            System.err.println("GLCgFXEffect:  2f semantic is null");
        }
    }

    public void setVecParameterBySemantic(String string, float f, float f2, float f3) {
        CGparameter cGparameter = CgGL.cgGetEffectParameterBySemantic((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgSetParameter3f((CGparameter)cGparameter, (float)f, (float)f2, (float)f3);
        } else {
            System.err.println("GLCgFXEffect:  3f semantic is null");
        }
    }

    public void setVecParameterBySemantic(String string, float f, float f2, float f3, float f4) {
        CGparameter cGparameter = CgGL.cgGetEffectParameterBySemantic((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgSetParameter4f((CGparameter)cGparameter, (float)f, (float)f2, (float)f3, (float)f4);
        } else {
            System.err.println("GLCgFXEffect:  4f semantic is null");
        }
    }

    public void setMatParameterBySemantic(String string, float f, float f2, float f3, float f4) {
        CGparameter cGparameter = CgGL.cgGetEffectParameterBySemantic((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            float[] fArray = new float[4];
            fArray[0] = f;
            fArray[1] = f3;
            fArray[4] = f2;
            fArray[5] = f4;
            CgGL.cgGLSetMatrixParameterfr((CGparameter)cGparameter, (float[])fArray, (int)0);
        } else {
            System.err.println("GLCgFXEffect:  matrix2x2f semantic is null");
        }
    }

    public void setMatParameterBySemantic(String string, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        CGparameter cGparameter = CgGL.cgGetEffectParameterBySemantic((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            float[] fArray = new float[9];
            fArray[0] = f;
            fArray[1] = f4;
            fArray[2] = f7;
            fArray[4] = f2;
            fArray[5] = f5;
            fArray[6] = f8;
            fArray[8] = f3;
            fArray[9] = f6;
            fArray[10] = f9;
            CgGL.cgGLSetMatrixParameterfr((CGparameter)cGparameter, (float[])fArray, (int)0);
        } else {
            System.err.println("GLCgFXEffect:  matrix3x3f semantic is null");
        }
    }

    public void setMatParameterBySemantic(String string, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        CGparameter cGparameter = CgGL.cgGetEffectParameterBySemantic((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            float[] fArray = new float[]{f, f5, f9, f13, f2, f6, f10, f14, f3, f7, f11, f15, f4, f8, f12, f16};
            CgGL.cgGLSetMatrixParameterfr((CGparameter)cGparameter, (float[])fArray, (int)0);
        } else {
            System.err.println("GLCgFXEffect:  matrix4x4f semantic is null");
        }
    }

    public void setMatrixParameterBySemantic(String string, float[] fArray) {
        CGparameter cGparameter = CgGL.cgGetEffectParameterBySemantic((CGeffect)this.effect, (String)string);
        if (cGparameter != null) {
            CgGL.cgGLSetMatrixParameterfr((CGparameter)cGparameter, (float[])fArray, (int)0);
        } else {
            System.err.println("GLCgFXEffect:  cgGLSetMatrixParameterfr(v[]) is null");
        }
    }

    public int getCgMatrixTransform(int n) {
        if (n == 0) {
            return 0;
        }
        if (n == 3) {
            return 3;
        }
        if (n == 1) {
            return 2;
        }
        if (n == 2) {
            return 1;
        }
        return -1;
    }

    protected void load(String string) {
        int n = 0;
        String[] stringArray = this.parent.loadStrings(string);
        this.replaceIncludes(stringArray);
        String string2 = PApplet.join((String[])stringArray, (String)"\n");
        this.effect = (CGeffect)GLState.createCGResource(8, this.context, string2);
        n = CgGL.cgGetError();
        if (this.effect == null) {
            System.err.println("GLCgFXEffect:  Effect file '" + string + "' not loaded correctly");
            n = CgGL.cgGetError();
            System.err.println("GLCgFXEffect:  Error String: " + CgGL.cgGetErrorString((int)n));
            System.err.println("GLCgFXEffect:  Last Listing: " + CgGL.cgGetLastListing((CGcontext)this.context));
        }
    }

    protected void release() {
        if (this.effect != null) {
            GLState.deleteCGResource(this.effect, 8);
            this.effect = null;
        }
        if (this.context != null) {
            GLState.deleteCGResource(this.context, 6);
            this.context = null;
        }
    }

    protected void replaceIncludes(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2 = stringArray[i];
            int n = string2.indexOf("#include");
            if (-1 >= n) continue;
            String string3 = string2.substring(n + 8, string2.length());
            string3 = string3.replace('\"', ' ');
            string3 = string3.trim();
            String[] stringArray2 = this.parent.loadStrings(string3);
            stringArray[i] = string = PApplet.join((String[])stringArray2, (String)"\n");
        }
    }

    private void checkCgError() {
        int n = CgGL.cgGetError();
        if (n != 0) {
            throw new RuntimeException("CG error: " + CgGL.cgGetErrorString((int)n));
        }
    }
}

