/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.glgraphics;

import codeanticode.glgraphics.GLShader;
import codeanticode.glgraphics.GLState;
import codeanticode.glgraphics.GLTexture;
import codeanticode.glgraphics.GLUtils;
import com.sun.opengl.util.BufferUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import processing.core.PApplet;

public class GLSLShader
extends GLShader {
    protected int programObject = GLState.createGLResource(4);
    protected int vertexShader = 0;
    protected int geometryShader = 0;
    protected int fragmentShader = 0;
    protected boolean initialized = false;
    protected int maxOutVertCount;

    public GLSLShader(PApplet pApplet) {
        super(pApplet);
        IntBuffer intBuffer = IntBuffer.allocate(1);
        this.gl.glGetIntegerv(36320, intBuffer);
        this.maxOutVertCount = intBuffer.get(0);
    }

    public GLSLShader(PApplet pApplet, String string, String string2) {
        this(pApplet);
        this.loadVertexShader(string);
        this.loadFragmentShader(string2);
        this.setup();
    }

    public GLSLShader(PApplet pApplet, String string, String string2, String string3) {
        this(pApplet);
        this.loadVertexShader(string);
        this.loadGeometryShader(string2);
        this.loadFragmentShader(string3);
    }

    public void delete() {
        this.release();
    }

    public void loadVertexShader(String string) {
        String string2 = PApplet.join((String[])this.parent.loadStrings(string), (String)"\n");
        this.attachVertexShader(string2, string);
    }

    public void loadVertexShader(URL uRL) {
        try {
            String string = PApplet.join((String[])PApplet.loadStrings((InputStream)uRL.openStream()), (String)"\n");
            this.attachVertexShader(string, uRL.getFile());
        }
        catch (IOException iOException) {
            System.err.println("Cannot load file " + uRL.getFile());
        }
    }

    public void loadGeometryShader(String string) {
        String string2 = PApplet.join((String[])this.parent.loadStrings(string), (String)"\n");
        this.attachGeometryShader(string2, string);
    }

    public void loadGeometryShader(URL uRL) {
        try {
            String string = PApplet.join((String[])PApplet.loadStrings((InputStream)uRL.openStream()), (String)"\n");
            this.attachGeometryShader(string, uRL.getFile());
        }
        catch (IOException iOException) {
            System.err.println("Cannot load file " + uRL.getFile());
        }
    }

    public void loadFragmentShader(String string) {
        String string2 = PApplet.join((String[])this.parent.loadStrings(string), (String)"\n");
        this.attachFragmentShader(string2, string);
    }

    public void loadFragmentShader(URL uRL) {
        try {
            String string = PApplet.join((String[])PApplet.loadStrings((InputStream)uRL.openStream()), (String)"\n");
            this.attachFragmentShader(string, uRL.getFile());
        }
        catch (IOException iOException) {
            System.err.println("Cannot load file " + uRL.getFile());
        }
    }

    public void setup() {
        this.gl.glLinkProgramARB(this.programObject);
        this.gl.glValidateProgramARB(this.programObject);
        this.checkLogInfo("GLSL program validation: ", this.programObject);
        this.initialized = true;
    }

    public int getMaxOutVertCount() {
        return this.maxOutVertCount;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void start() {
        if (!this.initialized) {
            System.err.println("This shader is not properly initialized. Call the setup() method first");
        }
        this.gl.glUseProgramObjectARB(this.programObject);
    }

    public void stop() {
        this.gl.glUseProgramObjectARB(0);
    }

    public void setupGeometryShader(int n, int n2) {
        int n3 = GLUtils.parsePrimitive(n);
        int n4 = GLUtils.parsePrimitive(n2);
        this.setupGeometryShaderImpl(n3, n4, this.maxOutVertCount);
    }

    public void setupGeometryShader(int n, int n2, int n3) {
        int n4 = GLUtils.parsePrimitive(n);
        int n5 = GLUtils.parsePrimitive(n2);
        this.setupGeometryShaderImpl(n4, n5, n3);
    }

    public void setupGeometryShader(String string, String string2) {
        int n = GLUtils.parsePrimitive(string);
        int n2 = GLUtils.parsePrimitive(string2);
        this.setupGeometryShaderImpl(n, n2, this.maxOutVertCount);
    }

    public void setupGeometryShader(String string, String string2, int n) {
        int n2 = GLUtils.parsePrimitive(string);
        int n3 = GLUtils.parsePrimitive(string2);
        this.setupGeometryShaderImpl(n2, n3, n);
    }

    protected void setupGeometryShaderImpl(int n, int n2, int n3) {
        this.gl.glProgramParameteriEXT(this.programObject, 36315, n);
        this.gl.glProgramParameteriEXT(this.programObject, 36316, n2);
        if (n3 < 0 || this.maxOutVertCount < n3) {
            n3 = this.maxOutVertCount;
        }
        this.gl.glProgramParameteriEXT(this.programObject, 36314, n3);
        this.setup();
    }

    public int getAttribLocation(String string) {
        return this.gl.glGetAttribLocationARB(this.programObject, string);
    }

    public int getUniformLocation(String string) {
        return this.gl.glGetUniformLocationARB(this.programObject, string);
    }

    public void setTexUniform(String string, int n) {
        int n2 = this.getUniformLocation(string);
        if (-1 < n2) {
            this.gl.glUniform1iARB(n2, n);
        }
    }

    public void setTexUniform(String string, GLTexture gLTexture) {
        int n = this.getUniformLocation(string);
        if (-1 < n) {
            int n2 = gLTexture.getTextureUnit();
            if (-1 < n2) {
                this.gl.glUniform1iARB(n, n2);
            }
            gLTexture.setTexUniform(n);
        }
    }

    public void setIntUniform(String string, int n) {
        int n2 = this.getUniformLocation(string);
        if (-1 < n2) {
            this.gl.glUniform1iARB(n2, n);
        }
    }

    public void setFloatUniform(String string, float f) {
        int n = this.getUniformLocation(string);
        if (-1 < n) {
            this.gl.glUniform1fARB(n, f);
        }
    }

    public void setVecUniform(String string, float f, float f2) {
        int n = this.getUniformLocation(string);
        if (-1 < n) {
            this.gl.glUniform2fARB(n, f, f2);
        }
    }

    public void setVecUniform(String string, float f, float f2, float f3) {
        int n = this.getUniformLocation(string);
        if (-1 < n) {
            this.gl.glUniform3fARB(n, f, f2, f3);
        }
    }

    public void setVecUniform(String string, float f, float f2, float f3, float f4) {
        int n = this.getUniformLocation(string);
        if (-1 < n) {
            this.gl.glUniform4f(n, f, f2, f3, f4);
        }
    }

    public void setMatUniform(String string, float f, float f2, float f3, float f4) {
        int n = this.getUniformLocation(string);
        if (-1 < n) {
            float[] fArray = new float[4];
            fArray[0] = f;
            fArray[1] = f3;
            fArray[4] = f2;
            fArray[5] = f4;
            this.gl.glUniformMatrix2fvARB(n, 1, false, fArray, 0);
        }
    }

    public void setMatUniform(String string, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        int n = this.getUniformLocation(string);
        if (-1 < n) {
            float[] fArray = new float[9];
            fArray[0] = f;
            fArray[1] = f4;
            fArray[2] = f7;
            fArray[4] = f2;
            fArray[5] = f5;
            fArray[6] = f8;
            fArray[8] = f3;
            fArray[9] = f6;
            fArray[10] = f9;
            this.gl.glUniformMatrix3fvARB(n, 1, false, fArray, 0);
        }
    }

    public void setMatUniform(String string, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        int n = this.getUniformLocation(string);
        if (-1 < n) {
            float[] fArray = new float[]{f, f5, f9, f13, f2, f6, f10, f14, f3, f7, f11, f15, f4, f8, f12, f16};
            this.gl.glUniformMatrix4fvARB(n, 1, false, fArray, 0);
        }
    }

    public void setFloatAttribute(String string, float f) {
        int n = this.getAttribLocation(string);
        if (-1 < n) {
            this.gl.glVertexAttrib1fARB(n, f);
        }
    }

    public void setVecAttribute(String string, float f, float f2) {
        int n = this.getAttribLocation(string);
        if (-1 < n) {
            this.gl.glVertexAttrib2fARB(n, f, f2);
        }
    }

    public void setVecAttribute(String string, float f, float f2, float f3) {
        int n = this.getAttribLocation(string);
        if (-1 < n) {
            this.gl.glVertexAttrib3fARB(n, f, f2, f3);
        }
    }

    public void setVecAttribute(String string, float f, float f2, float f3, float f4) {
        int n = this.getAttribLocation(string);
        if (-1 < n) {
            this.gl.glVertexAttrib4fARB(n, f, f2, f3, f4);
        }
    }

    private void attachVertexShader(String string, String string2) {
        this.vertexShader = GLState.createGLResource(5, 35633);
        this.gl.glShaderSourceARB(this.vertexShader, 1, new String[]{string}, (int[])null, 0);
        this.gl.glCompileShaderARB(this.vertexShader);
        this.checkLogInfo("Vertex shader " + string2 + " compilation: ", this.vertexShader);
        this.gl.glAttachObjectARB(this.programObject, this.vertexShader);
    }

    private void attachGeometryShader(String string, String string2) {
        this.geometryShader = GLState.createGLResource(5, 36313);
        this.gl.glShaderSourceARB(this.geometryShader, 1, new String[]{string}, (int[])null, 0);
        this.gl.glCompileShaderARB(this.geometryShader);
        this.checkLogInfo("Geometry shader " + string2 + " compilation: ", this.geometryShader);
        this.gl.glAttachObjectARB(this.programObject, this.geometryShader);
    }

    private void attachFragmentShader(String string, String string2) {
        this.fragmentShader = GLState.createGLResource(5, 35632);
        this.gl.glShaderSourceARB(this.fragmentShader, 1, new String[]{string}, (int[])null, 0);
        this.gl.glCompileShaderARB(this.fragmentShader);
        this.checkLogInfo("Fragment shader " + string2 + " compilation: ", this.fragmentShader);
        this.gl.glAttachObjectARB(this.programObject, this.fragmentShader);
    }

    protected void checkLogInfo(String string, int n) {
        IntBuffer intBuffer = BufferUtil.newIntBuffer((int)1);
        this.gl.glGetObjectParameterivARB(n, 35716, intBuffer);
        int n2 = intBuffer.get();
        if (n2 <= 1) {
            return;
        }
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer((int)n2);
        intBuffer.flip();
        this.gl.glGetInfoLogARB(n, n2, intBuffer, byteBuffer);
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        System.err.println(string);
        System.err.println(new String(byArray));
    }

    protected void release() {
        if (this.vertexShader != 0) {
            GLState.deleteGLResource(this.vertexShader, 5);
            this.vertexShader = 0;
        }
        if (this.geometryShader != 0) {
            GLState.deleteGLResource(this.geometryShader, 5);
            this.geometryShader = 0;
        }
        if (this.fragmentShader != 0) {
            GLState.deleteGLResource(this.fragmentShader, 5);
            this.fragmentShader = 0;
        }
        if (this.programObject != 0) {
            GLState.deleteGLResource(this.programObject, 4);
            this.programObject = 0;
        }
    }
}

